import java.io.IOException;
import java.io.RandomAccessFile;

public class USBPort implements Runnable {
   private Thread monThread;
   private RandomAccessFile rAF;
   private String portName;

   public USBPort(String portName) {
      this.portName = portName;
      monThread = new Thread(this);
   }

   public void start() {
      try {
         rAF = new java.io.RandomAccessFile(portName, "rwd");
      } 
      catch (Exception e) {
         System.out.println("start " + e.toString());
      }
      
      monThread.start();
   }

   public void run() {
      System.out.println("Lecture du port " + portName);
      for (int i = 0; i < 10; i++) {
         String response = null;
         try {
            response = rAF.readLine();
         } 
         catch (IOException e) {
            System.out.println(e.getMessage());
         }
         System.out.println(response);
      }
      
      System.out.println("USBPort termin (run)");
      System.exit(0);
   }

   public static void main(String[] args) {
      String portDevice = "COM3";
      if (args.length > 0) {
         portDevice = args[0];
      }
      
      USBPort usbPort = new USBPort(portDevice);
      usbPort.start();
      
      try {
        Thread.sleep(50000);
      } 
      catch (InterruptedException e) {
      }
      
      System.out.println("USBPort termin");
      System.exit(0);
   }
}