//Définition des broches
const int relayPin = 7;  //fil violet
const int trigPin  = 9;  //fil orange
const int echoPin  = 10; //fil vert

//Définition des variables
long duration;
int  distance;
int  nbignore = 0;
unsigned long time = 0;

void setup() {
  Serial.begin(9600);       //vitesse communication série
  Serial.println("Lancement de relais_distance");
  
  pinMode(relayPin, OUTPUT);
  digitalWrite(relayPin, LOW);

  pinMode(trigPin, OUTPUT); //trigPin comme Output
  pinMode(echoPin, INPUT);  //echoPin comme Input
}

void loop() {
  delay(100);  //Pas trop souvent, 100ms
  
  //Clear le trigPin
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);

  //trigPin HIGH state pour 10 micro seconds
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  //Lecture echoPin pour l'onde sonore retour en microsecondes
  duration = pulseIn(echoPin, HIGH);

  //Calcul de distance
  distance = duration*0.034/2; 

  nbignore++; //2 premiers ignorés
  if (nbignore > 2) {
    if (time == 0) {
      if ((distance > 5) && (distance < 100)) {
        //Montre la distance sur le port série
        Serial.print("Distance: ");
        Serial.println(distance);
        Serial.println("Relais ON");
        digitalWrite(relayPin, HIGH);
        time = millis();
      }
    }
    else {
      if ((millis() - time) > 4000) {
         if ((distance <= 5) || (distance >= 100)) {
           Serial.println("Relais OFF");
           digitalWrite(relayPin, LOW);
           time = 0;
         }
      }
    }
  }
}
