﻿using UnityEngine;
using System.Collections;

public class BallController : MonoBehaviour {
    [Tooltip("Rebound force.")]
    [SerializeField]
    private int force = 200;
    private Rigidbody rb;
    private Vector3 initialPosition;

    void Start()
    {
        initialPosition = transform.position;
        rb = GetComponent<Rigidbody>();
    }

    void Update()
    {
        if (Input.anyKeyDown)
        {
            transform.position = initialPosition;
        }
    }

    void OnCollisionEnter(Collision collision)
    {
        switch (collision.gameObject.tag)
        {
            case "Player":
                rb.AddForce(0, force, 0);
                break;
            case "Ground":
                Debug.Log("Game Over");
                break;
        }
    }
}
