/***************************************************************************
            GenerateMethod.cpp  -  generate class with rpc methods
                             -------------------
    begin                : Sun June 03 2007
    email                : ulxmlrpcpp@ewald-arnold.de

    $Id: GenerateMethod.cpp 1020 2007-07-23 09:09:26Z ewald-arnold $

 ***************************************************************************/

/**************************************************************************
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ***************************************************************************/

#include "GenerateMethod.h"
#include "UlxrIdlClass.h"

#include <iostream>
#include <fstream>

#include <sys/stat.h>

#include <ulxmlrpcpp/ulxr_http_protocol.h>

#ifdef _MSC_VER
#  include <ulxmlrpcpp/ulxr_config-msvc.h>

#elif defined(__BORLANDC__)
# include <ulxmlrpcpp/ulxr_config-bcb5.h>

#elif defined(__CYGWIN__)
# ifdef HAVE_CONFIG_H
#  include <config.h>
# else
#  include <ulxmlrpcpp/ulxr_config.h>
# endif
#else

# ifdef HAVE_CONFIG_H
#  include <config.h>
# else
#  include <ulxmlrpcpp/ulxr_config.h>
# endif
#endif


bool GenerateMethod::date_output = true;


void GenerateMethod::setDateOutput(bool output)
{
  date_output = output;
}


GenerateMethod::~GenerateMethod()
{
}

std::string GenerateMethod::dateString()
{
  if (date_output)
    return std::string("// Generated: ") + ulxr::getLatin1(ulxr::HttpProtocol::getDateStr()) + "\n";
  else
    return "";

}


void GenerateMethod::generateHeaderHead(std::ostream & h_file,
                                        const std::string &name)
{
  h_file << "#ifndef " << name + "_H\n"
         << "#define " << name + "_H\n"
         << "\n"
           << "///////////////////////////////////////////////////////////////////\n"
           << "// Automatically generated by xml2ulxr v" << ULXR_VERSION << ".\n"
           << dateString()
           << "//\n"
           << "// xml2ulxr is part of Ultra Lightweight XML RPC for C++.\n"
           << "// See also http://ulxmlrpcpp.sourceforge.net\n"
           << "//\n"
           << "// Don't edit manually unless you know what you are doing\n"
           << "///////////////////////////////////////////////////////////////////\n"
         << "\n\n";

  h_file << "//#define ULXR_UNICODE_ONLY_HELPERS\n"
            "#include <ulxmlrpcpp/ulxmlrpcpp.h> // always first\n\n";
}


void GenerateMethod::generateHeaderTail(std::ostream & h_file,
                                        const std::string &name)
{
  h_file << "};\n\n";
  h_file << "#endif // " << name + "_H\n\n";
}


void GenerateMethod::generateSourceHead(std::ostream & cpp_file,
                                        const std::string &h_name)
{
  cpp_file << "///////////////////////////////////////////////////////////////////\n"
           << "// Automatically generated by xml2ulxr v" << ULXR_VERSION << ".\n"
           << dateString()
           << "//\n"
           << "// xml2ulxr is part of Ultra Lightweight XML RPC for C++.\n"
           << "// See also http://ulxmlrpcpp.sourceforge.net\n"
           << "//\n"
           << "// Don't edit manually unless you know what you are doing\n"
           << "///////////////////////////////////////////////////////////////////\n"
           << "\n";

  cpp_file << "//#define ULXR_UNICODE_ONLY_HELPERS\n"
              "#include <ulxmlrpcpp/ulxmlrpcpp.h> // always first\n\n";

  cpp_file << "#include \"" << h_name << "\"\n\n";
}


void GenerateMethod::generateUserSourceHead(std::ostream & cpp_file,
                                            const std::string &h_name)
{
  cpp_file << "///////////////////////////////////////////////////////////////////\n"
           << "// Automatically generated by xml2ulxr v" << ULXR_VERSION << ".\n"
           << dateString()
           << "//\n"
           << "// xml2ulxr is part of Ultra Lightweight XML RPC for C++.\n"
           << "// See also http://ulxmlrpcpp.sourceforge.net\n"
           << "//\n"
           << "// Intended for manual and persistent changes \n"
           << "/////////////////////////////////////////////////\n"
           << "\n";

  cpp_file << "//#define ULXR_UNICODE_ONLY_HELPERS\n"
              "#include <ulxmlrpcpp/ulxmlrpcpp.h> // always first\n\n";
  cpp_file << "#include <ulxmlrpcpp/ulxr_value.h>\n";
  cpp_file << "#include \"" << h_name << "\"\n\n";
}


void GenerateMethod::generate_NameDefines(const std::string &destdir,
                                          const std::string &name,
                                          const std::vector<Method> &theMethods,
                                          const std::string &suffix)
{
  std::string h_name = destdir + name + "_ulxr_names.h";

  struct stat statbuf;
  if (stat(h_name.c_str(), &statbuf) >= 0)
  {
    std::cout << "User file already exists: " << h_name << std::endl;
    h_name += ".new";
    std::cout << "New template will be created: " << h_name << std::endl;
  }

  std::ofstream h_file(h_name.c_str());
  std::cout << "Header file will be created: " << h_name << std::endl;

  h_file << "///////////////////////////////////////////////////////////////////\n"
         << "// Automatically generated by xml2ulxr v" << ULXR_VERSION << ".\n"
         << dateString()
         << "//\n"
         << "// xml2ulxr is part of Ultra Lightweight XML RPC for C++.\n"
         << "// See also http://ulxmlrpcpp.sourceforge.net\n"
         << "//\n"
         << "// Intended for manual and persistent changes \n"
         << "/////////////////////////////////////////////////\n"
         << "\n";

  h_file << "#ifndef " << name + "_names_H\n"
         << "#define " << name + "_names_H\n\n\n"
         << "// method names\n\n";

  for (unsigned i = 0; i < theMethods.size(); ++i)
  {
    Method method = theMethods[i];
    method.extractNamespace();

    h_file << "// mapped to: " << method.getCppString(0, true, "");
    if (method.getName() != method.getOverloadName())
       h_file << " (there are overloaded methods)";
    h_file << "\n";

    h_file << "#define ULXR_CALLTO_" << suffix << method.getOverloadName(true, "_", "")
           << " \\\n  ULXR_PCHAR(\"" << name << "_" << method.getOverloadName(false) << "\")\n\n";
  }

  h_file << "\n#endif // " << name + "_H\n";
}



