﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Runtime.InteropServices.WindowsRuntime;
using System.Threading.Tasks;
using Windows.Devices.Geolocation;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Maps;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Newtonsoft.Json;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=402352&clcid=0x409

namespace DefibrillezMoi
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        private const string DEFIBRILLATEURS_API_URL =
            "http://odata.bordeaux.fr/v1/databordeaux/defibrillateurs/?format=json";

        public MainPage()
        {
            this.InitializeComponent();
            myMap.Center =
                new Geopoint(new BasicGeoposition()
                {
                    // Coordonées GPS de Bordeaux en degrés décimaux
                    Latitude = 44.840,
                    Longitude = -0.580
                });
            myMap.ZoomLevel = 13;
            // Récupération des emplacements des défibrillateurs
            GetDefibrillateursAsync();
        }

        private async Task GetDefibrillateursAsync()
        {
            var httpClient = new HttpClient();
            var jsonResponse = await httpClient.GetStringAsync(DEFIBRILLATEURS_API_URL);
            var result = await Task.Factory.StartNew(() => JsonConvert.DeserializeObject<Rootobject>(jsonResponse));
            foreach (var defib in result.d)
            {
                var mapIcon = new MapIcon();
                var position = new BasicGeoposition
                {
                    Longitude = double.Parse(defib.x_long),
                    Latitude = double.Parse(defib.y_lat)
                };
                mapIcon.Location = new Geopoint(position);
                mapIcon.Title = defib.nom;
                myMap.MapElements.Add(mapIcon);
            }
        }
    }
}
