﻿using System;
using Microsoft.Ccr.Core;

namespace DemoCausualty
{
    class Program
    {
        Port<int> lePort;
        Port<Exception> exceptionPort;
        Dispatcher leDispatcher;
        DispatcherQueue leDispatcherQueue;
        Receiver<int> leReceiver;
        Receiver<Exception> leReceiverException;
        Causality leCausality;

        Program()
        {
            lePort = new Port<int>();
            exceptionPort = new Port<Exception>();
            leDispatcher = new Dispatcher(1, "Mon Dispatcher");
            leDispatcherQueue = new DispatcherQueue("Mon DispatcherQueue", leDispatcher);
            leCausality = new Causality("pb à la racine", exceptionPort);
            Dispatcher.AddCausality(leCausality);
        }

        void Go()
        {
            leReceiver = Arbiter.Receive<int>(
                true,
                lePort,
                Rappel);

            leReceiverException = Arbiter.Receive<Exception>(
                true,
                exceptionPort,
                RappelException);

            Arbiter.Activate(leDispatcherQueue, leReceiver);
            // Activer le mécanisme de gestion d'erreur
            Arbiter.Activate(leDispatcherQueue, leReceiverException);

            lePort.Post(10);
            lePort.Post(5);
            lePort.Post(0);

            Console.ReadLine();
        }

        void Rappel(int valeur)
        {
            int result = 100 / valeur;
            Console.WriteLine(result);
        }

        void RappelException(Exception ex)
        {
            Console.WriteLine(ex);
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Go();
        }
    }
}
