﻿using System;
using System.Collections.Generic;
using Microsoft.Ccr.Core;

namespace DemoIteratorSequential
{
    class Program
    {
        Port<int> lePort;
        Dispatcher leDispatcher;
        DispatcherQueue leDispatcherQueue;
        Receiver<int> leReceiver;
        int result = 0;

        Program()
        {
            lePort = new Port<int>();
            leDispatcher = new Dispatcher(1, "Mon Dispatcher");
            leDispatcherQueue = new DispatcherQueue("Mon DispatcherQueue", leDispatcher);
        }

        void Go()
        {
            leReceiver = Arbiter.ReceiveWithIterator<int>(
                false,
                lePort,
                Rappel);

            Arbiter.Activate(leDispatcherQueue, leReceiver);
            Console.WriteLine("Itérateur activé");
            // Provoque l'entrée dans la fonction de Rappel
            lePort.Post(0);
            Console.ReadLine();
        }

        IEnumerator<ITask> Rappel(int valeur)
        {
            for (int i = 1; i < 10; i++)
            {
                lePort.Post(i);
                yield return lePort.Receive();
                result += lePort;
                Console.WriteLine(result);
            }
            Console.WriteLine("Résultat final {0}", result);
        }


        static void Main(string[] args)
        {
            Program p = new Program();
            p.Go();
        }
    }
}
