﻿using System;
using Microsoft.Ccr.Core;

namespace DemoPortSet
{
    class Program
    {
        PortSet<int, double, String> lePortSet;
        Dispatcher leDispatcher;
        DispatcherQueue leDispatcherQueue;
        Receiver<int> leIntReceiver;
        Receiver<double> leDoubleReceiver;
        Receiver<String> leStringReceiver;

        Program()
        {
            lePortSet = new PortSet<int, double, String>();
            leDispatcher = new Dispatcher(1, "Mon Dispatcher");
            leDispatcherQueue = new DispatcherQueue("Mon DispatcherQueue", leDispatcher);
        }

        void Go()
        {

            leIntReceiver = Arbiter.Receive<int>(
                true,
                lePortSet,
                IntHandler);

            leDoubleReceiver = Arbiter.Receive<double>(
                true,
                lePortSet,
                DoubleHandler);

            leStringReceiver = Arbiter.Receive<String>(
                true,
                lePortSet,
                StringHandler);


            Arbiter.Activate(leDispatcherQueue,
                leIntReceiver, leDoubleReceiver, leStringReceiver);

            lePortSet.Post(1);
            lePortSet.Post(1.0);
            lePortSet.Post("Programmez!");
            lePortSet.Post(2.0f);
        }

        void IntHandler(int valeur)
        {
            Console.WriteLine("Reçu entier: {0}", valeur);
        }
        void DoubleHandler(double valeur)
        {
            Console.WriteLine("Reçu double: {0}", valeur);
        }
        void StringHandler(String valeur)
        {
            Console.WriteLine("Reçu chaine: {0}", valeur);
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Go();
        }
    }
}
