﻿using System;
using Microsoft.Ccr.Core;

namespace SimplePort
{
    class Program
    {
        Port<int> lePort;
        Dispatcher leDispatcher;
        DispatcherQueue leDispatcherQueue;
        Receiver<int> leReceiver;

        Program()
        {
            lePort = new Port<int>();
            leDispatcher = new Dispatcher(10, "Mon Dispatcher");
            leDispatcherQueue = new DispatcherQueue("Mon DispatcherQueue", leDispatcher);
        }

        void Go()
        {
            
            leReceiver = Arbiter.Receive<int>(
                true,
                lePort,
                Rappel);
            
            /*
            leReceiver = Arbiter.Receive<int>(
                true,
                lePort,
                delegate(int valeur) { Console.WriteLine(valeur); });
            */

            /*
            leReceiver = Arbiter.Receive<int>(
               true,
                lePort,
                 valeur => Console.WriteLine(valeur));
             */ 

            /* Avec prédicat
            leReceiver = Arbiter.Receive<int>(
               true,
                lePort,
                 valeur => Console.WriteLine(valeur),
                 valeur => valeur%2 == 0);
            */

            Arbiter.Activate(leDispatcherQueue, leReceiver);

            for (int i = 0; i < 10; i++)
            {
                lePort.Post(i);
            }
            Console.ReadLine();
        }

        void Rappel(int valeur)
        {
            Console.WriteLine(valeur);
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Go();
        }
    }
}
