/**
 * <copyright> </copyright>
 * 
 * $Id: LogoCSMSwitch.java,v 1.1 2008-05-28 12:47:10 vmahe Exp $
 */
package org.openembedd.logo.csm.logoCSM.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.openembedd.logo.csm.logoCSM.Back;
import org.openembedd.logo.csm.logoCSM.BinaryExp;
import org.openembedd.logo.csm.logoCSM.Block;
import org.openembedd.logo.csm.logoCSM.Clear;
import org.openembedd.logo.csm.logoCSM.Constant;
import org.openembedd.logo.csm.logoCSM.ControlStructure;
import org.openembedd.logo.csm.logoCSM.Div;
import org.openembedd.logo.csm.logoCSM.Equals;
import org.openembedd.logo.csm.logoCSM.Expression;
import org.openembedd.logo.csm.logoCSM.Forward;
import org.openembedd.logo.csm.logoCSM.Greater;
import org.openembedd.logo.csm.logoCSM.If;
import org.openembedd.logo.csm.logoCSM.Instruction;
import org.openembedd.logo.csm.logoCSM.Left;
import org.openembedd.logo.csm.logoCSM.LogoCSMPackage;
import org.openembedd.logo.csm.logoCSM.Lower;
import org.openembedd.logo.csm.logoCSM.Minus;
import org.openembedd.logo.csm.logoCSM.Mult;
import org.openembedd.logo.csm.logoCSM.Parameter;
import org.openembedd.logo.csm.logoCSM.ParameterCall;
import org.openembedd.logo.csm.logoCSM.PenDown;
import org.openembedd.logo.csm.logoCSM.PenUp;
import org.openembedd.logo.csm.logoCSM.Plus;
import org.openembedd.logo.csm.logoCSM.Primitive;
import org.openembedd.logo.csm.logoCSM.ProcCall;
import org.openembedd.logo.csm.logoCSM.ProcDeclaration;
import org.openembedd.logo.csm.logoCSM.Repeat;
import org.openembedd.logo.csm.logoCSM.Right;
import org.openembedd.logo.csm.logoCSM.While;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance hierarchy. It supports the call
 * {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the inheritance hierarchy until a non-null result is
 * returned, which is the result of the switch. <!-- end-user-doc -->
 * 
 * @see org.openembedd.logo.csm.logoCSM.LogoCSMPackage
 * @generated
 */
public class LogoCSMSwitch<T>
{
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static LogoCSMPackage	modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LogoCSMSwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = LogoCSMPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that
	 * result. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject)
	{
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that
	 * result. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject)
	{
		if (theEClass.eContainer() == modelPackage)
		{
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else
		{
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that
	 * result. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
		case LogoCSMPackage.INSTRUCTION:
		{
			Instruction instruction = (Instruction) theEObject;
			T result = caseInstruction(instruction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PRIMITIVE:
		{
			Primitive primitive = (Primitive) theEObject;
			T result = casePrimitive(primitive);
			if (result == null)
				result = caseInstruction(primitive);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.BACK:
		{
			Back back = (Back) theEObject;
			T result = caseBack(back);
			if (result == null)
				result = casePrimitive(back);
			if (result == null)
				result = caseInstruction(back);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.FORWARD:
		{
			Forward forward = (Forward) theEObject;
			T result = caseForward(forward);
			if (result == null)
				result = casePrimitive(forward);
			if (result == null)
				result = caseInstruction(forward);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.LEFT:
		{
			Left left = (Left) theEObject;
			T result = caseLeft(left);
			if (result == null)
				result = casePrimitive(left);
			if (result == null)
				result = caseInstruction(left);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.RIGHT:
		{
			Right right = (Right) theEObject;
			T result = caseRight(right);
			if (result == null)
				result = casePrimitive(right);
			if (result == null)
				result = caseInstruction(right);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PEN_DOWN:
		{
			PenDown penDown = (PenDown) theEObject;
			T result = casePenDown(penDown);
			if (result == null)
				result = casePrimitive(penDown);
			if (result == null)
				result = caseInstruction(penDown);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PEN_UP:
		{
			PenUp penUp = (PenUp) theEObject;
			T result = casePenUp(penUp);
			if (result == null)
				result = casePrimitive(penUp);
			if (result == null)
				result = caseInstruction(penUp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.CLEAR:
		{
			Clear clear = (Clear) theEObject;
			T result = caseClear(clear);
			if (result == null)
				result = casePrimitive(clear);
			if (result == null)
				result = caseInstruction(clear);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.EXPRESSION:
		{
			Expression expression = (Expression) theEObject;
			T result = caseExpression(expression);
			if (result == null)
				result = caseInstruction(expression);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.BINARY_EXP:
		{
			BinaryExp binaryExp = (BinaryExp) theEObject;
			T result = caseBinaryExp(binaryExp);
			if (result == null)
				result = caseExpression(binaryExp);
			if (result == null)
				result = caseInstruction(binaryExp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.CONSTANT:
		{
			Constant constant = (Constant) theEObject;
			T result = caseConstant(constant);
			if (result == null)
				result = caseExpression(constant);
			if (result == null)
				result = caseInstruction(constant);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PROC_CALL:
		{
			ProcCall procCall = (ProcCall) theEObject;
			T result = caseProcCall(procCall);
			if (result == null)
				result = caseExpression(procCall);
			if (result == null)
				result = caseInstruction(procCall);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PROC_DECLARATION:
		{
			ProcDeclaration procDeclaration = (ProcDeclaration) theEObject;
			T result = caseProcDeclaration(procDeclaration);
			if (result == null)
				result = caseInstruction(procDeclaration);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.BLOCK:
		{
			Block block = (Block) theEObject;
			T result = caseBlock(block);
			if (result == null)
				result = caseInstruction(block);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.IF:
		{
			If if_ = (If) theEObject;
			T result = caseIf(if_);
			if (result == null)
				result = caseControlStructure(if_);
			if (result == null)
				result = caseInstruction(if_);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.CONTROL_STRUCTURE:
		{
			ControlStructure controlStructure = (ControlStructure) theEObject;
			T result = caseControlStructure(controlStructure);
			if (result == null)
				result = caseInstruction(controlStructure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.REPEAT:
		{
			Repeat repeat = (Repeat) theEObject;
			T result = caseRepeat(repeat);
			if (result == null)
				result = caseControlStructure(repeat);
			if (result == null)
				result = caseInstruction(repeat);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.WHILE:
		{
			While while_ = (While) theEObject;
			T result = caseWhile(while_);
			if (result == null)
				result = caseControlStructure(while_);
			if (result == null)
				result = caseInstruction(while_);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PARAMETER:
		{
			Parameter parameter = (Parameter) theEObject;
			T result = caseParameter(parameter);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PARAMETER_CALL:
		{
			ParameterCall parameterCall = (ParameterCall) theEObject;
			T result = caseParameterCall(parameterCall);
			if (result == null)
				result = caseExpression(parameterCall);
			if (result == null)
				result = caseInstruction(parameterCall);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.PLUS:
		{
			Plus plus = (Plus) theEObject;
			T result = casePlus(plus);
			if (result == null)
				result = caseBinaryExp(plus);
			if (result == null)
				result = caseExpression(plus);
			if (result == null)
				result = caseInstruction(plus);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.MINUS:
		{
			Minus minus = (Minus) theEObject;
			T result = caseMinus(minus);
			if (result == null)
				result = caseBinaryExp(minus);
			if (result == null)
				result = caseExpression(minus);
			if (result == null)
				result = caseInstruction(minus);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.MULT:
		{
			Mult mult = (Mult) theEObject;
			T result = caseMult(mult);
			if (result == null)
				result = caseBinaryExp(mult);
			if (result == null)
				result = caseExpression(mult);
			if (result == null)
				result = caseInstruction(mult);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.DIV:
		{
			Div div = (Div) theEObject;
			T result = caseDiv(div);
			if (result == null)
				result = caseBinaryExp(div);
			if (result == null)
				result = caseExpression(div);
			if (result == null)
				result = caseInstruction(div);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.EQUALS:
		{
			Equals equals = (Equals) theEObject;
			T result = caseEquals(equals);
			if (result == null)
				result = caseBinaryExp(equals);
			if (result == null)
				result = caseExpression(equals);
			if (result == null)
				result = caseInstruction(equals);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.GREATER:
		{
			Greater greater = (Greater) theEObject;
			T result = caseGreater(greater);
			if (result == null)
				result = caseBinaryExp(greater);
			if (result == null)
				result = caseExpression(greater);
			if (result == null)
				result = caseInstruction(greater);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case LogoCSMPackage.LOWER:
		{
			Lower lower = (Lower) theEObject;
			T result = caseLower(lower);
			if (result == null)
				result = caseBinaryExp(lower);
			if (result == null)
				result = caseExpression(lower);
			if (result == null)
				result = caseInstruction(lower);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Instruction</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Instruction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInstruction(Instruction object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Primitive</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Primitive</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePrimitive(Primitive object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Back</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Back</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBack(Back object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Forward</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Forward</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseForward(Forward object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Left</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Left</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLeft(Left object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Right</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Right</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRight(Right object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Pen Down</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Pen Down</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePenDown(PenDown object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Pen Up</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Pen Up</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePenUp(PenUp object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clear</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clear</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClear(Clear object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpression(Expression object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Binary Exp</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Binary Exp</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBinaryExp(BinaryExp object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstant(Constant object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Proc Call</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Proc Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcCall(ProcCall object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Proc Declaration</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Proc Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcDeclaration(ProcDeclaration object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Block</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBlock(Block object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>If</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>If</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIf(If object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Control Structure</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Control Structure</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseControlStructure(ControlStructure object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Repeat</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Repeat</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRepeat(Repeat object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>While</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>While</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWhile(While object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameter(Parameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter Call</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameterCall(ParameterCall object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Plus</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Plus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePlus(Plus object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Minus</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Minus</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMinus(Minus object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mult</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mult</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMult(Mult object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Div</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Div</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDiv(Div object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Equals</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Equals</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEquals(Equals object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Greater</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Greater</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGreater(Greater object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Lower</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Lower</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLower(Lower object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate the switch, but this is the last case
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @param object
	 *        the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object)
	{
		return null;
	}

} // LogoCSMSwitch
