//
// Blinky
//
// Description of the project
// Developed with [embedXcode](http://embedXcode.weebly.com)
//
// Author 		Reno
// 				MyOrganization
//
// Date			23/09/2016 16:07
// Version		
//
// Copyright	© , 2016
// Licence		
//
// See         ReadMe.txt for references
//


// Core library for code-sense - IDE-based
#if defined(WIRING) // Wiring specific
	#include "Wiring.h"
#elif defined(MAPLE_IDE) // Maple specific
	#include "WProgram.h"
#elif defined(MPIDE) // chipKIT specific
	#include "WProgram.h"
#elif defined(DIGISPARK) // Digispark specific
	#include "Arduino.h"
#elif defined(ENERGIA) // LaunchPad specific
	#include "Energia.h"
#elif defined(LITTLEROBOTFRIENDS) // LittleRobotFriends specific
	#include "LRF.h"
#elif defined(MICRODUINO) // Microduino specific
	#include "Arduino.h"
#elif defined(SPARK) || defined(PARTICLE) // Particle / Spark specific
	#include "Arduino.h"
#elif defined(TEENSYDUINO) // Teensy specific
	#include "Arduino.h"
#elif defined(REDBEARLAB) // RedBearLab specific
	#include "Arduino.h"
#elif defined(ESP8266) // ESP8266 specific
	#include "Arduino.h"
#elif defined(ARDUINO) // Arduino 1.0 and 1.5 specific
	#include "Arduino.h"
#else // error
	#error Platform not defined
#endif // end IDE

// Set parameters


// Include application, user and local libraries
#include <EEPROM.h>

// Prototypes


// Define variables and constants
const int _address = 0x00;

// Add setup code
void setup()
{
	Serial.begin(9600);     // Init connexion série.
	EEPROM.begin();         // Init EEPROM.
}

// Add loop code
void loop()
{
	int rnd = random(255);   // Nombre aléatoire entre 0 et 255;
	
	EEPROM.write(_address, (uint8_t)rnd);   // écrit la valeur dans l'EEPROM à l'adresse 0x00.
	delay(50);      // délai pour être sûr que la valeur est bien écrite dans l'EEPROM.
	
	uint8_t readValue = EEPROM.read(_address);  // Lit la valeur à l'adresse 0x00.
	
	Serial.print("Valeur attendue: "+String(rnd));
	Serial.println(", valeur lue dans l'EEPROM: "+String(readValue));
	delay(1500);
}
