//
// Blinky
//
// Description of the project
// Developed with [embedXcode](http://embedXcode.weebly.com)
//
// Author 		Reno
// 				MyOrganization
//
// Date			23/09/2016 16:07
// Version		
//
// Copyright	© , 2016
// Licence		
//
// See         ReadMe.txt for references
//


// Core library for code-sense - IDE-based
#if defined(WIRING) // Wiring specific
	#include "Wiring.h"
#elif defined(MAPLE_IDE) // Maple specific
	#include "WProgram.h"
#elif defined(MPIDE) // chipKIT specific
	#include "WProgram.h"
#elif defined(DIGISPARK) // Digispark specific
	#include "Arduino.h"
#elif defined(ENERGIA) // LaunchPad specific
	#include "Energia.h"
#elif defined(LITTLEROBOTFRIENDS) // LittleRobotFriends specific
	#include "LRF.h"
#elif defined(MICRODUINO) // Microduino specific
	#include "Arduino.h"
#elif defined(SPARK) || defined(PARTICLE) // Particle / Spark specific
	#include "Arduino.h"
#elif defined(TEENSYDUINO) // Teensy specific
	#include "Arduino.h"
#elif defined(REDBEARLAB) // RedBearLab specific
	#include "Arduino.h"
#elif defined(ESP8266) // ESP8266 specific
	#include "Arduino.h"
#elif defined(ARDUINO) // Arduino 1.0 and 1.5 specific
	#include "Arduino.h"
#else // error
	#error Platform not defined
#endif // end IDE

// Set parameters


// Include application, user and local libraries

#include <Keypad.h>

// Prototypes


// Define variables and constants

#define kKeypadRows         4       // nombre de rangées sur le clavier.
#define kKeypadCols         20      // nombre de colonnes sur le clavier.

byte _keypadRowPins[kKeypadRows] = {2,3,4,5};  // broches Arduino pour les rangées du clavier.
byte _keypadColPins[kKeypadCols] = {6,7,8};    // broches Arduino pour les colonnes du clavier.

// Tableau représentant le mapping des caractères sur le clavier:
char _keypadKeys[kKeypadRows][kKeypadCols] = {
	{'1','2','3'},
	{'4','5','6'},
	{'7','8','9'},
	{'*','0','#'},
};

// Initialisiation de l'objet global clavier:
Keypad _keypad = Keypad(makeKeymap(_keypadKeys), _keypadRowPins, _keypadColPins, kKeypadRows, kKeypadCols);

// Add setup code
void setup()
{
	Serial.begin(9600);     // Init connexion série.
	
}

// Add loop code
void loop()
{
	// Obtention de la touche appuyée (s'il y en a une):
	char key = _keypad.getKey();
	
	// Si une touche est appuyée:
	if (key != NO_KEY)
	{
		// On écrit la touche appuyée:
		Serial.print(key);
	}

}
