﻿using System;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace DemoRegex
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            //CheckDuplicatedWords();
            Split();
        }

        /// <summary>
        /// Vérifie la validité de la chaine passée en paramètre
        /// </summary>
        public static bool ValidMail(string adresse)
        {
            //Note : Placer @ pour éviter de doubler les caractères d'échappement de la chaîne
            var myRegex = new Regex(@"^([\w]+)@([\w]+)\.([\w]+)$");
            return myRegex.IsMatch(adresse);
        }

        /// <summary>
        /// Vérifie si les valeures saisies d'un champs sont de type numérique
        /// </summary>
        public void OnTextChanged(object sender, EventArgs e)
        {

            if (!Regex.IsMatch(textBox.Text, "^[0-9]+$"))
            {
                textBox.Text = string.Empty;
                MessageBox.Show("Erreur : valeur attendue de type numérique");
            }
        }

        /// <summary>
        /// Formatte une chaîne de caractère
        /// </summary>
        public string FormatPath(string oldPath)
        {
            //return oldPath.Replace(@"\", @"\\");
            return Regex.Replace(oldPath, @"\", @"\\");
        }


        public void FormatComplexe()
        {
            string input = "23x * y34x2";
            // on sépare les groupes de chiffres/lettres par un *
            Regex reg = new Regex(@"\d(?=[a-z])|[a-z](?=\d)");
            string result = reg.Replace(input, delegate(Match m)
            {
                return m.Value + " * ";
            }); 
        }
        // output : 23 * x * y * 34 * x * 2



        public void CheckDuplicatedWords()
        {
            string input = "Les Google Glass Glass sont des lunettes lunettes... ";
            
            string pattern = @"(\w+)\s(\1)";
            // (\w+) -->  un ou plusieurs caractères alphabétiques.
            // \s    -->  un espace blanc.
            // (\1)  -->  la chaîne dans le premier groupe capturé
            // \W    -->  un caractère non-alphabétique, notamment l'espace blanc et ponctuation.

            foreach (Match match in Regex.Matches(input, pattern, RegexOptions.IgnoreCase))
                Console.WriteLine("Mots dupliqué '{0}' trouvé aux positions {1} et {2}.",
                                  match.Groups[1].Value,
                                  match.Groups[1].Index,
                                  match.Groups[2].Index);

        }
        //Résultats
        //Mots dupliqués 'Glass' trouvés aux positions 11 et 17.
        //Mots dupliqués 'lunettes' trouvés aux positions 32 et 41.

        /// <summary>
        /// Découpe une chaîne en fontion de ses espaces, retour charriot et virgule
        /// </summary>
        public void Split()
        {
            String s1 = "Oculus Rift : la réalité virtuelle à portée de code ?";
            char[] seps = { ' ', '\n', ',' };
            // séparateur = espace, retour charriot, virgule
            String[] values = s1.Split(seps);
            foreach (string value in values)
            {
                Console.WriteLine(value);
            }
        }

        


    }
}
