# Contributing

First of all read our [Code of Conduct](https://github.com/kataras/iris/blob/master/CODE_OF_CONDUCT.md).

## PR

1. Open a new [issue](https://github.com/kataras/iris/issues/new)
    * Write version of your local Iris.
    * Write version of your local Go programming language.
    * Describe your problem, what did you expect to see and what you see instead.
        * If it's a feature request, describe your idea as better as you can
          * optionally, navigate to the [chat](https://kataras.rocket.chat/channel/iris) to push other members to participate and share their thoughts about your brilliant idea.
2. Fork the [repository](https://github.com/kataras/iris).
3. Make your changes.
4. Compare & Push the PR from [here](https://github.com/kataras/iris/compare).

## Donate

Help this project to continue deliver awesome and unique features with the higher code quality as possible by donating any amount via [PayPal](https://www.paypal.me/kataras) or [BTC](https://iris-go.com/donate)!

| Name | Amount | Membership |
| -----------|--------|--------|
| [Juan Sebastián Suárez Valencia](https://github.com/Juanses) | 20 EUR |  Bronze |
| [Bob Lee](https://github.com/li3p) | 20 EUR |  Bronze |
| [Celso Luiz](https://github.com/celsosz) | 50 EUR |  **Silver** |
| [Ankur Srivastava](https://github.com/ansrivas) | 20 EUR |  Bronze |
| [Damon Zhao](https://github.com/se77en) | 20 EUR |  Bronze |
| [Exponity - Tech Company](https://github.com/exponity) | 30 EUR |  Bronze |
| [Thomas Fritz](https://github.com/thomasfr) | 25 EUR |  Bronze |
| [Thanos V.](http://mykonosbiennale.com/) | 20 EUR |  Bronze |
| [George Opritescu](https://github.com/International) | 20 EUR |  Bronze |
| [Lex Tang](https://github.com/lexrus) | 20 EUR |  Bronze |
| [Bill Q.](https://github.com/hiveminded) | 600 EUR |  **Gold** |
| [Conrad Steenberg](https://github.com/hengestone) | 25 EUR |  Bronze |

## Translate

We need your help with translations into your native language.

Iris needs your help, please think about contributing to the translation of the [README](README.md) and https://iris-go.com, you will be rewarded.

Instructions can be found at: https://github.com/kataras/iris/issues/796

## Share

### Writing

Write an article about Iris in https://medium.com , https://dev.to or if you're being a hackathon at https://hackernoon.com, some examples:

* [A Todo MVC Application using Iris and Vue.js](https://hackernoon.com/a-todo-mvc-application-using-iris-and-vue-js-5019ff870064)
* [A Hasura starter project with a ready to deploy Golang hello-world web app with IRIS](bit.ly/2lmKaAZ)
* [Top 6 web frameworks for Go as of 2017](https://blog.usejournal.com/top-6-web-frameworks-for-go-as-of-2017-23270e059c4b)
* [Iris Go Framework + MongoDB](https://medium.com/go-language/iris-go-framework-mongodb-552e349eab9c)
* [How to build a file upload form using DropzoneJS and Go](https://hackernoon.com/how-to-build-a-file-upload-form-using-dropzonejs-and-go-8fb9f258a991)
* [How to display existing files on server using DropzoneJS and Go](https://hackernoon.com/how-to-display-existing-files-on-server-using-dropzonejs-and-go-53e24b57ba19)
* [Iris Go vs .NET Core Kestrel in terms of HTTP performance](https://hackernoon.com/iris-go-vs-net-core-kestrel-in-terms-of-http-performance-806195dc93d5)
* [Go vs .NET Core in terms of HTTP performance](https://medium.com/@kataras/go-vs-net-core-in-terms-of-http-performance-7535a61b67b8)
* [Iris, a modular web framework](https://medium.com/@corebreaker/iris-web-cd684b4685c7)
* [How to Turn an Android Device into a Web Server](https://twitter.com/ThePracticalDev/status/892022594031017988)
* [A URL Shortener Service using Go, Iris and Bolt](https://medium.com/@kataras/a-url-shortener-service-using-go-iris-and-bolt-4182f0b00ae7)

### Social networks

If you're part of any social network, do a post(or tweet if twitter) about Iris and what you love about it, many examples can be found, the most recent one is [that](https://www.facebook.com/eliaswalyba/posts/1462004807202379).

### Work

Convince your colleagues to try the Iris web framework at dev environment and if they choose to proceed on production, contact with [us](mailto:kataras2006@hotmail.com?subject=Iris%20Production) for further instructions, if you need any help.

Many young people are choosing Iris for their postgraduate studies as well.

## Documentation

We're preparing the new version of the [Build A Better Web, Together](https://github.com/kataras/build-a-better-web-together) Go book, which is a type of documentation of Iris web framework as well.

If you want to be part of this and you've time for collaboration, please open a new [issue](https://github.com/kataras/build-a-better-web-together/issues/new) and write some words about yourself and your overall experience at tech. At the end of the day you will be granded with `write access` in order to push your sections without our approval at all.

All new contributors of that book will receive prizes!

### Contributors

Thank you to all the people who have already <a href="graphs/contributors">contributed</a> to Iris!

### Backers

Thank you to all our backers! [Become a backer](https://iris-go.com/donate)

<a href="https://iris-go.com/donate"><img src="https://iris-go.com/backers.svg?v=2"/></a>
