import React, { useState } from 'react';

const DogForm = props => {

  console.log('DogsForm');

  // const [dog, setDog] = useState({ name: '', price: '' });
  const [name, setName] = useState('');
  const [price, setPrice] = useState('');

  const submitHandler = event => {
    event.preventDefault();

    const newDog = {
      name: name,
      price: price
    };

    props.onAdd(newDog);

    setName('');
    setPrice('');
  };


  return (
    <section className="dog-form">
      <form onSubmit={submitHandler}>
        <div>
          <label>Nom : </label>
          <input
            type="text"
            id="name"
            value={name}
            onChange={event => {
              setName(event.target.value);
            }} />
        </div>
        <div>
          <label>Prix : </label>
          <input
            type="text"
            id="price"
            value={price}
            onChange={event => {
              setPrice(event.target.value);
            }} />
        </div>
        <div>
          <input type="submit" value="Ajouter" />
        </div>
      </form>
    </section>
  );
};

export default DogForm;