import React from 'react';
import Spiner from '../UI/Spiner';




const DogList = props => {
  console.log('DogList');

  const removeHandler = dog => event => {
    event.preventDefault();
    props.onRemove(dog.id);
  }

  return (
    <section className="dog-list">
      <h2>Liste des chiens</h2>
      {props.loading && <Spiner />}
      <ul>
        {props.dogs.map(dog => (
          <li key={dog.id}>
            <span className="name">{dog.name} : </span>
            <span className="price">{dog.price}€</span>
            <button onClick={removeHandler(dog)}>Effacer</button>
          </li>
        ))}
      </ul>
    </section>
  );
};

export default DogList;
