import React, { useCallback, useEffect, useMemo, useReducer } from 'react';

// import apiFetch from './apifetch';

import DogForm from './DogForm';
import DogList from './DogList';
import ErrorBox from '../UI/ErrorBox';

import { useApiFetch } from './myHooks';


const dogReducer = (currentDogs, action) => {
  switch (action.type) {
    case 'GET':
      return action.dogs;

    case 'ADD':
      return [...currentDogs, action.dog];

    case 'REMOVE':
      return currentDogs.filter(dog => dog.id !== action.dogId);

    default:
      throw new Error('The specified action type is not correct!');
  }
};





const Dogs = () => {

  const [dogs, dispatchDogAction] = useReducer(dogReducer, []);
  // const [apiFetchState, dispatchApiFetchStateAction] 
  //     = useReducer(apiFetchStateReducer, { loading: false, error: null });
  const [{ loading, error, data, extra, method }, call] = useApiFetch();


  useEffect(() => {
    if (loading || error) {
      return;
    }

    if (method === 'DELETE') {
      dispatchDogAction({ type: 'REMOVE', dogId: extra });
    } else if (method === 'POST') {
      dispatchDogAction({ type: 'ADD', dog: data });
    } else if (method === 'GET') {
      dispatchDogAction({ type: 'GET', dogs: data });
    }
  }, [data, extra, method, loading, error]);


  useEffect(() => {
    call('https://some-website.com/api/dogs', 'GET');
  }, [call]);


  const addDogHandler = useCallback(dog => {
    call('https://some-website.com/api/dogs', 'POST', JSON.stringify(dog), { 'Content-Type': 'application/json' });
  }, [call]);

  const removeDogHandler = useCallback(dogId => {
    call('https://some-website.com/api/dogs/' + dogId, 'DELETE', {}, {}, dogId);
  }, [call]);


  const dogForm = useMemo(() => {
    return (
      <DogForm onAdd={addDogHandler} />
    )
  }, [addDogHandler]);


  const dogList = useMemo(() => {
    return (
      <DogList
        dogs={dogs}
        onRemove={removeDogHandler}
        loading={loading} />
    );
  }, [loading, removeDogHandler, dogs]);


  return (
    <div>
      {error && <ErrorBox errorMessage={error} />}
      <h1>Ma mini app de chiens</h1>
      <hr />
      {dogForm}
      <hr />
      {dogList}
    </div>
  );
}

export default Dogs;