
// FAKE API BEGIN

let apiDogs = [
  {
    id: 'hlspf',
    name: 'Milou',
    price: 12
  },
  {
    id: 'gdeth',
    name: 'Idefix',
    price: 32
  }
];

const API_SHOULD_FAIL = false;
const API_TIMEOUT = 2000; // 2 secondes


const apiFetch = (requestInfo, requestInit) => {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      console.log("Simulating fetch...");

      if (API_SHOULD_FAIL) {
        reject('Something went wrong!');
      }

      const method = (requestInit && requestInit.method) || 'GET';
      const body = requestInit && requestInit.body;
      const headers = requestInit && requestInit.headers;

      console.log('URL:', requestInfo);
      console.log('Method:', method);
      console.log('Body:', body);
      console.log('Headers:', headers);

      switch (method) {
        case 'GET':
          console.log("Getting all dogs...");
          resolve(apiDogs);
          break;

        case 'POST':
          console.log("Adding one dog...");
          const dog = JSON.parse(body);
          const newDog = {
            id: Math.random(), // Ca fera l'affaire pour ce tuto
            ...dog,
          };
          apiDogs = [...apiDogs, newDog];
          resolve(newDog);
          break;

        case 'DELETE':
          console.log("Deleting one dog (by id)...");
          const last = requestInfo.lastIndexOf('/');
          const id = requestInfo.substring(last);
          apiDogs = apiDogs.filter(dog => dog.id !== id);
          resolve();
          break;

        default:
          reject('Bad method!');
          break;
      }
    }, API_TIMEOUT);
  });
}

// FAKE API END

export default apiFetch;