import { useCallback, useReducer } from 'react';

import apiFetch from './apifetch';



const apiFetchStateReducer = (apiFetchState, action) => {
  switch (action.type) {
    case 'CALL':
      return { loading: true, error: null, data: null, extra: null, method: action.method };

    case 'RESULT':
      return { ...apiFetchState, loading: false, data: action.data, extra: action.extra, method: action.method };

    case 'ERROR':
      return { loading: false, error: action.error };

    default:
      throw new Error('The specified action type is not correct!');
  };
};


const useApiFetch = () => {
  const [apiFetchState, dispatchApiFetchStateAction]
    = useReducer(apiFetchStateReducer, {
      loading: false, error: null, data: null, extra: null, method: null
    });

  const call = useCallback((url, method, body, headers, extra) => {
    dispatchApiFetchStateAction({ type: 'CALL', method });
    apiFetch(url, { method, body, headers })
      .then(data => {
        dispatchApiFetchStateAction({ type: 'RESULT', data, extra, method });
      })
      .catch(e => {
        dispatchApiFetchStateAction({ type: 'ERROR', error: e });
      });
  }, []);

  const called = {
    loading: apiFetchState.loading,
    error: apiFetchState.error,
    data: apiFetchState.data,
    extra: apiFetchState.extra,
    method: apiFetchState.method,
  };

  return [called, call];
};

export { useApiFetch };
