import java.lang.management.ManagementFactory;

import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;


// Copyright (c) 2004-2005 Morgan Stanley Capital International, Inc., All Rights Reserved
//
// Unpublished copyright.  This material contains proprietary information
// that shall be used or copied only within Morgan Stanley Capital International,
// except with written permission of Morgan Stanley Capital International.
//
// Created on Jan 24, 2006 by Sebastien Marc (MSCI)
//
// $Revision$
//

public class Chrono extends NotificationBroadcasterSupport implements ChronoMBean
{

  private long secondes = 0;
  
  private boolean continuer = false;
  
  private synchronized boolean continuer() {
      return continuer;
  }
  public synchronized long getSecondes() {
    return secondes;
}
  
  public void run()
  {
    long premierTick = System.currentTimeMillis();
    long prochainTick = premierTick; // init.

    while (continuer())
    {
      // tant que le temps coul en ms n'atteint
      // pas la prochaine seconde
      while (prochainTick - premierTick < 1000)
      {
        try
        {
          Thread.sleep(5); // 5 ms de prcision
        }
        catch (InterruptedException e)
        {
          // pas grave
          System.err.println(e);
        }
        prochainTick = System.currentTimeMillis();
      }
      secondes++;
      premierTick = prochainTick; // init.
      try {
        sendNotification(new Notification (
                    "NotificationHorloge", this, 1, ""+getSecondes()));
      }
     catch (Exception e) {
      System.err.println (e);
  }

    }
  }
  
  public MBeanNotificationInfo[] getNotificationInfo() {
    String[] types = new String[] { "NotificationHorloge" };
    String name = "NotificationHorloge";
    String description = "Valeur du compteur";
    MBeanNotificationInfo info = new MBeanNotificationInfo
          (types, name, description);
    return new MBeanNotificationInfo[] { info };
}

  public void demarrer() {
    if(continuer == false)
    {
      continuer = true;
      run();
    }
  }    

  public synchronized void stop() {
    continuer = false;
}

  public static void main (final String[] args) {
    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer(); 
    
    ObjectName name;
    try {
        name = new ObjectName("Horloge:type=Horloge");
        Chrono mbean = new Chrono();
        mbs.registerMBean(mbean, name);
        Thread.sleep(Long.MAX_VALUE); // attendre trs longtemps   
    } catch (Exception e) {
      System.err.println(e);
    }
  }  

}
