#include <stdio.h>
#include <time.h> 

/*non recursive fibonacci function*/
unsigned int fib(unsigned int n)
{
	unsigned int fibminus2=0;
	unsigned int fibminus1=1;
	unsigned int fib=0;
	unsigned int i;
	if (n==0 || n==1) return n;
	
	for(i=2;i<=n;i++){
		fib=fibminus1+fibminus2;
		fibminus2=fibminus1;
		fibminus1=fib;
	}

	return fib;
}

int main(int argc, char **argv) 
{
	unsigned int n;
	if (argc < 2) {
		printf("usage: fib n\n"
			   "Compute nth Fibonacci number\n");
		return 1;
	}
	clock_t t1, t2;
	t1 = clock();   
		
	n = atoi(argv[1]);
	printf("fib(%d) = %d\n", n, fib(n));
	t2 = clock();   
	int diff = (((float)t2 - (float)t1));   // / 1000000.0F
	//float diff = (((float)t2 - (float)t1)); // / 1000000.0F ) * 1000;
	printf("time : %d ms",diff);   
	
	return 0;
}
