// Implementation file for parser generated by fsyacc
module Parser
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open Microsoft.FSharp.Text.Lexing
open Microsoft.FSharp.Text.Parsing.ParseHelpers
# 1 "Parser.fsy"

open AbstractSyntax

# 10 "Parser.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | EOF
  | DESINCR
  | AND
  | DOT
  | EQUAL
  | SEMI
  | COMMA
  | GREATER
  | LESS
  | GREATEREQUAL
  | LESSEQUAL
  | FUN
  | ARROW
  | RETURN
  | VAR
  | IF
  | ELSE
  | INCR
  | USE
  | PLUS
  | MINUS
  | LPAREN
  | RPAREN
  | LBRACE
  | RBRACE
  | TRUE
  | FALSE
  | STRING of (string)
  | INT of (int)
  | NAME of (string)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_EOF
    | TOKEN_DESINCR
    | TOKEN_AND
    | TOKEN_DOT
    | TOKEN_EQUAL
    | TOKEN_SEMI
    | TOKEN_COMMA
    | TOKEN_GREATER
    | TOKEN_LESS
    | TOKEN_GREATEREQUAL
    | TOKEN_LESSEQUAL
    | TOKEN_FUN
    | TOKEN_ARROW
    | TOKEN_RETURN
    | TOKEN_VAR
    | TOKEN_IF
    | TOKEN_ELSE
    | TOKEN_INCR
    | TOKEN_USE
    | TOKEN_PLUS
    | TOKEN_MINUS
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_LBRACE
    | TOKEN_RBRACE
    | TOKEN_TRUE
    | TOKEN_FALSE
    | TOKEN_STRING
    | TOKEN_INT
    | TOKEN_NAME
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startstart
    | NONTERM_start
    | NONTERM_File
    | NONTERM_PropertyInitializer
    | NONTERM_PropertiesInitializer
    | NONTERM_Variable
    | NONTERM_Parameters
    | NONTERM_Expression
    | NONTERM_Statement
    | NONTERM_StatementList

// This function maps tokens to integer indexes
let tagOfToken (t:token) = 
  match t with
  | EOF  -> 0 
  | DESINCR  -> 1 
  | AND  -> 2 
  | DOT  -> 3 
  | EQUAL  -> 4 
  | SEMI  -> 5 
  | COMMA  -> 6 
  | GREATER  -> 7 
  | LESS  -> 8 
  | GREATEREQUAL  -> 9 
  | LESSEQUAL  -> 10 
  | FUN  -> 11 
  | ARROW  -> 12 
  | RETURN  -> 13 
  | VAR  -> 14 
  | IF  -> 15 
  | ELSE  -> 16 
  | INCR  -> 17 
  | USE  -> 18 
  | PLUS  -> 19 
  | MINUS  -> 20 
  | LPAREN  -> 21 
  | RPAREN  -> 22 
  | LBRACE  -> 23 
  | RBRACE  -> 24 
  | TRUE  -> 25 
  | FALSE  -> 26 
  | STRING _ -> 27 
  | INT _ -> 28 
  | NAME _ -> 29 

// This function maps integer indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_EOF 
  | 1 -> TOKEN_DESINCR 
  | 2 -> TOKEN_AND 
  | 3 -> TOKEN_DOT 
  | 4 -> TOKEN_EQUAL 
  | 5 -> TOKEN_SEMI 
  | 6 -> TOKEN_COMMA 
  | 7 -> TOKEN_GREATER 
  | 8 -> TOKEN_LESS 
  | 9 -> TOKEN_GREATEREQUAL 
  | 10 -> TOKEN_LESSEQUAL 
  | 11 -> TOKEN_FUN 
  | 12 -> TOKEN_ARROW 
  | 13 -> TOKEN_RETURN 
  | 14 -> TOKEN_VAR 
  | 15 -> TOKEN_IF 
  | 16 -> TOKEN_ELSE 
  | 17 -> TOKEN_INCR 
  | 18 -> TOKEN_USE 
  | 19 -> TOKEN_PLUS 
  | 20 -> TOKEN_MINUS 
  | 21 -> TOKEN_LPAREN 
  | 22 -> TOKEN_RPAREN 
  | 23 -> TOKEN_LBRACE 
  | 24 -> TOKEN_RBRACE 
  | 25 -> TOKEN_TRUE 
  | 26 -> TOKEN_FALSE 
  | 27 -> TOKEN_STRING 
  | 28 -> TOKEN_INT 
  | 29 -> TOKEN_NAME 
  | 32 -> TOKEN_end_of_input
  | 30 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startstart 
    | 1 -> NONTERM_start 
    | 2 -> NONTERM_File 
    | 3 -> NONTERM_PropertyInitializer 
    | 4 -> NONTERM_PropertiesInitializer 
    | 5 -> NONTERM_PropertiesInitializer 
    | 6 -> NONTERM_Variable 
    | 7 -> NONTERM_Variable 
    | 8 -> NONTERM_Parameters 
    | 9 -> NONTERM_Parameters 
    | 10 -> NONTERM_Expression 
    | 11 -> NONTERM_Expression 
    | 12 -> NONTERM_Expression 
    | 13 -> NONTERM_Expression 
    | 14 -> NONTERM_Expression 
    | 15 -> NONTERM_Expression 
    | 16 -> NONTERM_Expression 
    | 17 -> NONTERM_Expression 
    | 18 -> NONTERM_Expression 
    | 19 -> NONTERM_Expression 
    | 20 -> NONTERM_Expression 
    | 21 -> NONTERM_Expression 
    | 22 -> NONTERM_Expression 
    | 23 -> NONTERM_Expression 
    | 24 -> NONTERM_Expression 
    | 25 -> NONTERM_Expression 
    | 26 -> NONTERM_Expression 
    | 27 -> NONTERM_Expression 
    | 28 -> NONTERM_Statement 
    | 29 -> NONTERM_Statement 
    | 30 -> NONTERM_Statement 
    | 31 -> NONTERM_StatementList 
    | 32 -> NONTERM_StatementList 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 32 
let _fsyacc_tagOfErrorTerminal = 30

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | EOF  -> "EOF" 
  | DESINCR  -> "DESINCR" 
  | AND  -> "AND" 
  | DOT  -> "DOT" 
  | EQUAL  -> "EQUAL" 
  | SEMI  -> "SEMI" 
  | COMMA  -> "COMMA" 
  | GREATER  -> "GREATER" 
  | LESS  -> "LESS" 
  | GREATEREQUAL  -> "GREATEREQUAL" 
  | LESSEQUAL  -> "LESSEQUAL" 
  | FUN  -> "FUN" 
  | ARROW  -> "ARROW" 
  | RETURN  -> "RETURN" 
  | VAR  -> "VAR" 
  | IF  -> "IF" 
  | ELSE  -> "ELSE" 
  | INCR  -> "INCR" 
  | USE  -> "USE" 
  | PLUS  -> "PLUS" 
  | MINUS  -> "MINUS" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | LBRACE  -> "LBRACE" 
  | RBRACE  -> "RBRACE" 
  | TRUE  -> "TRUE" 
  | FALSE  -> "FALSE" 
  | STRING _ -> "STRING" 
  | INT _ -> "INT" 
  | NAME _ -> "NAME" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | EOF  -> (null : System.Object) 
  | DESINCR  -> (null : System.Object) 
  | AND  -> (null : System.Object) 
  | DOT  -> (null : System.Object) 
  | EQUAL  -> (null : System.Object) 
  | SEMI  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | GREATER  -> (null : System.Object) 
  | LESS  -> (null : System.Object) 
  | GREATEREQUAL  -> (null : System.Object) 
  | LESSEQUAL  -> (null : System.Object) 
  | FUN  -> (null : System.Object) 
  | ARROW  -> (null : System.Object) 
  | RETURN  -> (null : System.Object) 
  | VAR  -> (null : System.Object) 
  | IF  -> (null : System.Object) 
  | ELSE  -> (null : System.Object) 
  | INCR  -> (null : System.Object) 
  | USE  -> (null : System.Object) 
  | PLUS  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | LBRACE  -> (null : System.Object) 
  | RBRACE  -> (null : System.Object) 
  | TRUE  -> (null : System.Object) 
  | FALSE  -> (null : System.Object) 
  | STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | NAME _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us; 65535us; 1us; 65535us; 0us; 1us; 1us; 65535us; 0us; 2us; 4us; 65535us; 11us; 12us; 28us; 9us; 29us; 9us; 30us; 9us; 3us; 65535us; 28us; 10us; 29us; 10us; 30us; 10us; 17us; 65535us; 0us; 15us; 4us; 15us; 7us; 14us; 29us; 15us; 30us; 15us; 40us; 14us; 42us; 15us; 45us; 14us; 47us; 15us; 57us; 14us; 58us; 14us; 59us; 14us; 60us; 14us; 61us; 14us; 64us; 14us; 65us; 14us; 66us; 14us; 1us; 65535us; 38us; 19us; 11us; 65535us; 7us; 8us; 40us; 41us; 45us; 46us; 57us; 49us; 58us; 50us; 59us; 51us; 60us; 52us; 61us; 53us; 64us; 54us; 65us; 55us; 66us; 56us; 6us; 65535us; 0us; 67us; 4us; 69us; 29us; 67us; 30us; 67us; 42us; 69us; 47us; 69us; 3us; 65535us; 0us; 4us; 29us; 42us; 30us; 47us; |]
let _fsyacc_sparseGotoTableRowOffsets = [|0us; 1us; 3us; 5us; 10us; 14us; 32us; 34us; 46us; 53us; |]
let _fsyacc_stateToProdIdxsTableElements = [| 1us; 0us; 1us; 0us; 1us; 1us; 1us; 1us; 2us; 2us; 32us; 1us; 3us; 2us; 3us; 6us; 1us; 3us; 6us; 3us; 23us; 24us; 25us; 26us; 27us; 1us; 4us; 2us; 5us; 17us; 1us; 5us; 1us; 5us; 1us; 6us; 3us; 7us; 10us; 11us; 2us; 7us; 29us; 1us; 7us; 1us; 7us; 1us; 8us; 3us; 9us; 21us; 22us; 1us; 9us; 1us; 9us; 1us; 10us; 1us; 10us; 1us; 12us; 1us; 13us; 1us; 14us; 1us; 15us; 2us; 16us; 17us; 3us; 16us; 17us; 20us; 3us; 16us; 17us; 22us; 1us; 16us; 1us; 17us; 1us; 18us; 1us; 18us; 1us; 18us; 1us; 18us; 4us; 19us; 20us; 21us; 22us; 4us; 19us; 20us; 21us; 22us; 2us; 19us; 20us; 2us; 19us; 20us; 6us; 19us; 23us; 24us; 25us; 26us; 27us; 2us; 20us; 32us; 1us; 20us; 2us; 21us; 22us; 2us; 21us; 22us; 6us; 21us; 23us; 24us; 25us; 26us; 27us; 2us; 22us; 32us; 1us; 22us; 6us; 23us; 23us; 24us; 25us; 26us; 27us; 6us; 23us; 24us; 24us; 25us; 26us; 27us; 6us; 23us; 24us; 25us; 25us; 26us; 27us; 6us; 23us; 24us; 25us; 26us; 26us; 27us; 6us; 23us; 24us; 25us; 26us; 27us; 27us; 6us; 23us; 24us; 25us; 26us; 27us; 28us; 6us; 23us; 24us; 25us; 26us; 27us; 29us; 6us; 23us; 24us; 25us; 26us; 27us; 30us; 1us; 23us; 1us; 24us; 1us; 25us; 1us; 26us; 1us; 27us; 1us; 28us; 1us; 28us; 1us; 28us; 1us; 29us; 1us; 30us; 1us; 31us; 1us; 31us; 1us; 32us; 1us; 32us; |]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us; 2us; 4us; 6us; 8us; 11us; 13us; 16us; 18us; 25us; 27us; 30us; 32us; 34us; 36us; 40us; 43us; 45us; 47us; 49us; 53us; 55us; 57us; 59us; 61us; 63us; 65us; 67us; 69us; 72us; 76us; 80us; 82us; 84us; 86us; 88us; 90us; 92us; 97us; 102us; 105us; 108us; 115us; 118us; 120us; 123us; 126us; 133us; 136us; 138us; 145us; 152us; 159us; 166us; 173us; 180us; 187us; 194us; 196us; 198us; 200us; 202us; 204us; 206us; 208us; 210us; 212us; 214us; 216us; 218us; 220us; |]
let _fsyacc_action_rows = 71
let _fsyacc_actionTableElements = [|3us; 32768us; 13us; 66us; 14us; 62us; 29us; 13us; 0us; 49152us; 1us; 32768us; 0us; 3us; 0us; 16385us; 3us; 16386us; 13us; 66us; 14us; 62us; 29us; 13us; 1us; 32768us; 4us; 7us; 1us; 16390us; 4us; 7us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 5us; 16387us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 0us; 16388us; 2us; 32768us; 6us; 11us; 24us; 32us; 1us; 32768us; 29us; 5us; 0us; 16389us; 0us; 16390us; 2us; 16395us; 3us; 16us; 21us; 22us; 2us; 32768us; 3us; 16us; 4us; 65us; 1us; 32768us; 29us; 17us; 0us; 16391us; 0us; 16392us; 2us; 32768us; 6us; 20us; 22us; 44us; 1us; 32768us; 29us; 21us; 0us; 16393us; 1us; 32768us; 22us; 23us; 0us; 16394us; 0us; 16396us; 0us; 16397us; 0us; 16398us; 0us; 16399us; 2us; 32768us; 24us; 31us; 29us; 5us; 4us; 32768us; 13us; 66us; 14us; 62us; 24us; 31us; 29us; 6us; 4us; 32768us; 13us; 66us; 14us; 62us; 24us; 31us; 29us; 6us; 0us; 16400us; 0us; 16401us; 1us; 32768us; 21us; 34us; 1us; 32768us; 29us; 35us; 1us; 32768us; 22us; 36us; 0us; 16402us; 1us; 32768us; 21us; 38us; 2us; 32768us; 22us; 39us; 29us; 18us; 1us; 32768us; 12us; 40us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 29us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 5us; 16403us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 4us; 32768us; 13us; 66us; 14us; 62us; 24us; 43us; 29us; 13us; 0us; 16404us; 1us; 32768us; 12us; 45us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 30us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 5us; 16405us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 4us; 32768us; 13us; 66us; 14us; 62us; 24us; 48us; 29us; 13us; 0us; 16406us; 5us; 16407us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16408us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16409us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16410us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16411us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16412us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16413us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 5us; 16414us; 7us; 57us; 8us; 58us; 9us; 59us; 10us; 60us; 19us; 61us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 1us; 32768us; 29us; 63us; 1us; 32768us; 4us; 64us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 8us; 32768us; 11us; 37us; 18us; 33us; 23us; 28us; 25us; 24us; 26us; 25us; 27us; 27us; 28us; 26us; 29us; 13us; 1us; 32768us; 5us; 68us; 0us; 16415us; 1us; 32768us; 5us; 70us; 0us; 16416us; |]
let _fsyacc_actionTableRowOffsets = [|0us; 4us; 5us; 7us; 8us; 12us; 14us; 16us; 25us; 31us; 32us; 35us; 37us; 38us; 39us; 42us; 45us; 47us; 48us; 49us; 52us; 54us; 55us; 57us; 58us; 59us; 60us; 61us; 62us; 65us; 70us; 75us; 76us; 77us; 79us; 81us; 83us; 84us; 86us; 89us; 91us; 100us; 106us; 111us; 112us; 114us; 123us; 129us; 134us; 135us; 141us; 147us; 153us; 159us; 165us; 171us; 177us; 183us; 192us; 201us; 210us; 219us; 228us; 230us; 232us; 241us; 250us; 259us; 261us; 262us; 264us; |]
let _fsyacc_reductionSymbolCounts = [|1us; 2us; 1us; 3us; 1us; 3us; 1us; 3us; 1us; 3us; 3us; 1us; 1us; 1us; 1us; 1us; 2us; 3us; 4us; 5us; 7us; 6us; 8us; 3us; 3us; 3us; 3us; 3us; 4us; 3us; 2us; 2us; 3us; |]
let _fsyacc_productionToNonTerminalTable = [|0us; 1us; 2us; 3us; 4us; 4us; 5us; 5us; 6us; 6us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 7us; 8us; 8us; 8us; 9us; 9us; |]
let _fsyacc_immediateActions = [|65535us; 49152us; 65535us; 16385us; 65535us; 65535us; 65535us; 65535us; 65535us; 16388us; 65535us; 65535us; 16389us; 16390us; 65535us; 65535us; 65535us; 16391us; 16392us; 65535us; 65535us; 16393us; 65535us; 16394us; 16396us; 16397us; 16398us; 16399us; 65535us; 65535us; 65535us; 16400us; 16401us; 65535us; 65535us; 65535us; 16402us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16404us; 65535us; 65535us; 65535us; 65535us; 16406us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16415us; 65535us; 16416us; |]
let _fsyacc_reductions ()  =    [| 
# 280 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  AbstractSyntax.Prog )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startstart));
# 289 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'File)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 25 "Parser.fsy"
                                       _1 
                   )
# 25 "Parser.fsy"
                 :  AbstractSyntax.Prog ));
# 300 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'StatementList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 28 "Parser.fsy"
                                           Program(List.rev(_1)) 
                   )
# 28 "Parser.fsy"
                 : 'File));
# 311 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 30 "Parser.fsy"
                                                                                                  PropertySetter(_1, _3) 
                   )
# 30 "Parser.fsy"
                 : 'PropertyInitializer));
# 323 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'PropertyInitializer)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 32 "Parser.fsy"
                                                                                                  [_1] 
                   )
# 32 "Parser.fsy"
                 : 'PropertiesInitializer));
# 334 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'PropertiesInitializer)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'PropertyInitializer)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 33 "Parser.fsy"
                                                                                                  _3::_1 
                   )
# 33 "Parser.fsy"
                 : 'PropertiesInitializer));
# 346 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 35 "Parser.fsy"
                                                                                                  Variable(_1) 
                   )
# 35 "Parser.fsy"
                 : 'Variable));
# 357 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Variable)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 36 "Parser.fsy"
                                                                                                  Property(_1, _3) 
                   )
# 36 "Parser.fsy"
                 : 'Variable));
# 369 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 38 "Parser.fsy"
                                                                                                  [_1] 
                   )
# 38 "Parser.fsy"
                 : 'Parameters));
# 380 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Parameters)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 39 "Parser.fsy"
                                                                                                  _3::_1 
                   )
# 39 "Parser.fsy"
                 : 'Parameters));
# 392 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Variable)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 41 "Parser.fsy"
                                                                                                  Call(_1) 
                   )
# 41 "Parser.fsy"
                 : 'Expression));
# 403 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Variable)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 42 "Parser.fsy"
                                                                                                  Get(_1) 
                   )
# 42 "Parser.fsy"
                 : 'Expression));
# 414 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 43 "Parser.fsy"
                                                                                                  Bool(true) 
                   )
# 43 "Parser.fsy"
                 : 'Expression));
# 424 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 44 "Parser.fsy"
                                                                                                  Bool(false) 
                   )
# 44 "Parser.fsy"
                 : 'Expression));
# 434 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : int)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 45 "Parser.fsy"
                                                                                                  Int(_1) 
                   )
# 45 "Parser.fsy"
                 : 'Expression));
# 445 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 46 "Parser.fsy"
                                                                                                  String(_1) 
                   )
# 46 "Parser.fsy"
                 : 'Expression));
# 456 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 47 "Parser.fsy"
                                                                                                  New([]) 
                   )
# 47 "Parser.fsy"
                 : 'Expression));
# 466 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'PropertiesInitializer)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 48 "Parser.fsy"
                                                                                                  New(List.rev(_2)) 
                   )
# 48 "Parser.fsy"
                 : 'Expression));
# 477 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 49 "Parser.fsy"
                                                                                                  Use(_3) 
                   )
# 49 "Parser.fsy"
                 : 'Expression));
# 488 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 50 "Parser.fsy"
                                                                                                  Fun([], [Return(_5)]) 
                   )
# 50 "Parser.fsy"
                 : 'Expression));
# 499 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : 'StatementList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 51 "Parser.fsy"
                                                                                                  Fun([], List.rev(_6)) 
                   )
# 51 "Parser.fsy"
                 : 'Expression));
# 510 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Parameters)) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 52 "Parser.fsy"
                                                                                                  Fun(List.rev(_3), [Return(_6)]) 
                   )
# 52 "Parser.fsy"
                 : 'Expression));
# 522 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Parameters)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : 'StatementList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 53 "Parser.fsy"
                                                                                                  Fun(List.rev(_3), List.rev(_7)) 
                   )
# 53 "Parser.fsy"
                 : 'Expression));
# 534 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 54 "Parser.fsy"
                                                                                                  Greater(_1, _3) 
                   )
# 54 "Parser.fsy"
                 : 'Expression));
# 546 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 55 "Parser.fsy"
                                                                                                  Less(_1, _3) 
                   )
# 55 "Parser.fsy"
                 : 'Expression));
# 558 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 56 "Parser.fsy"
                                                                                                  GreaterOrEqual(_1, _3) 
                   )
# 56 "Parser.fsy"
                 : 'Expression));
# 570 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 57 "Parser.fsy"
                                                                                                  LessOrEqual(_1, _3) 
                   )
# 57 "Parser.fsy"
                 : 'Expression));
# 582 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 58 "Parser.fsy"
                                                                                                  Add(_1, _3) 
                   )
# 58 "Parser.fsy"
                 : 'Expression));
# 594 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 60 "Parser.fsy"
                                                                                                  Create(_2, _4) 
                   )
# 60 "Parser.fsy"
                 : 'Statement));
# 606 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Variable)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 61 "Parser.fsy"
                                                                                                  Assign(_1, _3) 
                   )
# 61 "Parser.fsy"
                 : 'Statement));
# 618 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Expression)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 62 "Parser.fsy"
                                                                                                  Return(_2) 
                   )
# 62 "Parser.fsy"
                 : 'Statement));
# 629 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Statement)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 64 "Parser.fsy"
                                                                                                  [_1] 
                   )
# 64 "Parser.fsy"
                 : 'StatementList));
# 640 "Parser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'StatementList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Statement)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 65 "Parser.fsy"
                                                                                                  _2::_1 
                   )
# 65 "Parser.fsy"
                 : 'StatementList));
|]
# 653 "Parser.fs"
let tables () : Microsoft.FSharp.Text.Parsing.Tables<_> = 
  { reductions= _fsyacc_reductions ();
    endOfInputTag = _fsyacc_endOfInputTag;
    tagOfToken = tagOfToken;
    dataOfToken = _fsyacc_dataOfToken; 
    actionTableElements = _fsyacc_actionTableElements;
    actionTableRowOffsets = _fsyacc_actionTableRowOffsets;
    stateToProdIdxsTableElements = _fsyacc_stateToProdIdxsTableElements;
    stateToProdIdxsTableRowOffsets = _fsyacc_stateToProdIdxsTableRowOffsets;
    reductionSymbolCounts = _fsyacc_reductionSymbolCounts;
    immediateActions = _fsyacc_immediateActions;
    gotos = _fsyacc_gotos;
    sparseGotoTableRowOffsets = _fsyacc_sparseGotoTableRowOffsets;
    tagOfErrorTerminal = _fsyacc_tagOfErrorTerminal;
    parseError = (fun (ctxt:Microsoft.FSharp.Text.Parsing.ParseErrorContext<_>) -> 
                              match parse_error_rich with 
                              | Some f -> f ctxt
                              | None -> parse_error ctxt.Message);
    numTerminals = 33;
    productionToNonTerminalTable = _fsyacc_productionToNonTerminalTable  }
let engine lexer lexbuf startState = (tables ()).Interpret(lexer, lexbuf, startState)
let start lexer lexbuf :  AbstractSyntax.Prog  =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 0))
