// LambdaConsoleApp.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"


void Fn1()
{
	vector<int> v = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15 };
	auto it = std::find_if(v.begin(), v.end(),
		[](int val) { return val>=5; });
	while (it != v.end())
	{
		cout << *it << endl;
		++it;
	}
}

void Fn2()
{
	using FilterContainer = std::vector<std::function<bool(int)>>;
	FilterContainer filters;
	filters.emplace_back(
		[](int value) { return value % 5 == 0; }
	);
}

void addDivisorFilter()
{
	using FilterContainer = std::vector<std::function<bool(int)>>;
	FilterContainer filters;
	auto calc1 = 10;
	auto calc2 = 20;
	auto divisor = 30;
	filters.emplace_back( 
		[&](int value) { return value % divisor == 0; } 
	);
	filters.emplace_back(
		[&divisor](int value) { return value % divisor == 0; }
	);
	filters.emplace_back(
		[=](int value) { return value % divisor == 0; }
	);
}

void addDivisorFilter2()
{
	using FilterContainer = std::vector<std::function<bool(int)>>;
	FilterContainer filters;
	static auto calc1 = 10;
	static auto calc2 = 20;
	static auto divisor = 30;
	filters.emplace_back(
		[=](int value) { return value % divisor == 0; }
	);
	++divisor;
}

template<typename C>
void workWithContainer(const C& container)
{
	auto calc1 = 10;
	auto calc2 = 20;
	auto divisor = 30;
	using ContElemt = typename C::value_type;
	if (std::all_of(begin(container), end(container),
		[&](const ConstElemt& value)
	{
		return value % divisor == 0;
	}))
	{	}
	else
	{	}

	if( std::all_of(begin(container), end(container),
		[&](const auto& value)
	{
		return value % divisor == 0;
	}))
		;
}


class Widget
{
public:
	Widget() {}
	void addFilter();

	using FilterContainer = std::vector<std::function<bool(int)>>;
	FilterContainer filters;

private:
	int divisor = 10;
};

void Widget::addFilter()
{
	filters.emplace_back(
		[=](int value) { return value % divisor == 0; }
	);
	/*filters.emplace_back(
		[](int value) { return value % divisor == 0; }
	);
	filters.emplace_back(
		[divisor](int value) { return value % divisor == 0; }
	);*/
	auto currentObjectPtr = this;
	filters.emplace_back(
		[currentObjectPtr](int value) { return value % currentObjectPtr->divisor == 0; }
	);
	auto divisorCopy = divisor;
	filters.emplace_back(
		[divisorCopy](int value) { return value % divisorCopy == 0; }
	);
	filters.emplace_back(
		[=](int value) { return value % divisorCopy == 0; }
	);
	filters.emplace_back(
		[divisor = divisor](int value) { return value % divisor == 0; }
	);
}

using FilterContainer = std::vector<std::function<bool(int)>>;
FilterContainer filters;

void doSomeWork()
{
	auto pw = std::make_unique<Widget>();
	pw->addFilter();
}

int main()
{
	Fn1();
	Fn2();
	addDivisorFilter();
	return 0;
}


