'use strict';

/*
 * Defining the Package
 */
var Module = require('meanio').Module;

var Application = new Module('application');

/*
 * All MEAN packages require registration
 * Dependency injection is used to define required modules
 */
Application.register(function(app, auth, database, system, users) {

  // Initialisation des routes
  Application.routes(app, auth, database);

  // Ajout des entrées de menu pour les utilisateurs authentifiés
  Application.menus.add({
    'roles': ['authenticated'],
    'title': 'Tracks',
    'link': 'list tracks'
  });
  Application.menus.add({
    'roles': ['authenticated'],
    'title': 'New Track',
    'link': 'create track'
  });
  
  // Aggrégation des ressources statiques du module
  Application.aggregateAsset('css', 'application.css');

  // Dépendances AngularJS du module
  Application.angularDependencies(['mean.system', 'mean.users', 'leaflet-directive']);

  // Pathes are relative to public/assets and we install all dependencies at the top level to avoid clashes
  Application.aggregateAsset('css', '../../../../../../bower_components/leaflet/dist/leaflet.css');
  Application.aggregateAsset('css', '../../../../../../bower_components/cesium/Build/CesiumUnminified/Widgets/widgets.css');
  // Ensure map library is loaded first because default for aggregation is all in footer, without specific ordering
  Application.aggregateAsset('js', '../../../../../../bower_components/leaflet/dist/leaflet.js', {weight: -1});
  Application.aggregateAsset('js', '../../../../../../bower_components/cesium/Build/CesiumUnminified/Cesium.js', {weight: -1});
  Application.aggregateAsset('js', '../../../../../../bower_components/angular-leaflet-directive/dist/angular-leaflet-directive.js');
  
  /**
    //Uncomment to use. Requires meanio@0.3.7 or above
    // Save settings with callback
    // Use this for saving data from administration pages
    Application.settings({
        'someSetting': 'some value'
    }, function(err, settings) {
        //you now have the settings object
    });

    // Another save settings example this time with no callback
    // This writes over the last settings.
    Application.settings({
        'anotherSettings': 'some value'
    });

    // Get settings. Retrieves latest saved settigns
    Application.settings(function(err, settings) {
        //you now have the settings object
    });
    */

  return Application;
});
