'use strict';

// Contrôleur utilisé pour gérer les chemins
angular.module('mean.application').controller('TrackController', ['$scope', '$stateParams', '$location', 'TrackService', 
  function($scope, $stateParams, $location, TrackService) {
    // Objet par défaut pour le mode création
    $scope.track = { file: {} };
    // Créé un nouveau chemin
    $scope.create = function(isValid) {
      if (isValid) {
        var payload = {
          title: $scope.track.title,
          description: $scope.track.description
        };
        // Ajout du contenu du fichier si présent
        if ( $scope.track.file.content ) {
          payload[$scope.track.file.extension] = $scope.track.file.content;
        }
        var track = new TrackService(payload);
        track.$save(function(response) {
          $location.path('tracks');
        });

        $scope.track.title = '';
        $scope.track.description = '';
      } else {
        $scope.submitted = true;
      }
    };
    // Détruit un chemin existant
    $scope.remove = function(track) {
      if (track) {
        track.$remove(function(response) {
          for (var i in $scope.tracks) {
            if ($scope.tracks[i] === track) {
	             $scope.tracks.splice(i,1);
            }
          }
          $location.path('tracks');
        });
      } else {
        $scope.track.$remove(function(response) {
          $location.path('tracks');
        });
      }
    };
    // Met à jour un chemin existant
    $scope.update = function(isValid) {
      if (isValid) {
        var track = $scope.track;
        // Ajout du contenu du fichier si présent
        if ( track.file.content ) {
          track[track.file.extension] = track.file.content;
        }
        // Suppression des anciennes données dans la requête
        delete track.waypoints;
        delete track.bbox;
        track.$update(function() {
          $location.path('track/' + track._id);
        });
      } else {
        $scope.submitted = true;
      }
    };
    // Liste tous les chemins de l'utilisateur
    $scope.find = function() {
      TrackService.query(function(tracks) {
        $scope.tracks = tracks;
      });
    };
    //Récupère un chemin via son ID
    $scope.findOne = function() {
      TrackService.get({
        trackId: $stateParams.trackId
      }, function(track) {
        $scope.track = track;
        // Ajout de l'information de fichier pour édition
        $scope.track.file = {};
      });
    };
  }
]).directive("file", ['$log', function ($log) {
  return {
    scope: {
        file: "="
    },
    link: function (scope, element, attributes) {
      // A chaque  sélection d'un nouveaufichier nous le chargeons
      element.bind("change", function (changeEvent) {
        var reader = new FileReader();

        reader.onloadend = function() {
          var regex = /^([^\\]*)\.(\w+)$/;
          var matches = changeEvent.target.files[0].name.match(regex);

          if (matches) {
            var filename = matches[1];
            var extension = matches[2].toLowerCase();
            
            scope.$apply(function () {
              scope.file.content = reader.result;
              scope.file.filename = filename;
              scope.file.extension = extension;
            });
          }
        };

        reader.onerror = function() {
          $log.log( reader.error.message );
        };

        reader.readAsText( changeEvent.target.files[0] );
      });
    }
  }
}]);
