'use strict';

// Definition des routes pour les chemins
angular.module('mean.application').config(['$stateProvider',
  function($stateProvider) {

    // Page listant tous les chemins de l'utilisateur
    $stateProvider
      .state('list tracks', {
        url: '/tracks',
        templateUrl: '/application/views/ListTracks.html',
        controller: 'TrackController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      })
      // Page permettant de créer un nouveau chemin
      .state('create track', {
        url: '/track/create',
        templateUrl: '/application/views/CreateTrack.html',
        controller: 'TrackController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      })
      // Page permettant d'éditer un chemin
      .state('edit track', {
        url: '/track/:trackId/edit',
        templateUrl: '/application/views/EditTrack.html',
        controller: 'TrackController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      })
      // Page permettant de voir un chemin
      .state('view track', {
        url: '/track/:trackId',
        templateUrl: '/application/views/ViewTrack.html',
        controller: 'TrackController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      })
      // Page permettant de voir un chemin sur la carte
      .state('track map', {
        url: '/track/:trackId/map',
        templateUrl: '/application/views/TrackMap.html',
        controller: 'TrackMapController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      })
      // Page permettant de voir un chemin sur le globe
      .state('track globe', {
        url: '/track/:trackId/globe',
        templateUrl: '/application/views/TrackGlobe.html',
        controller: 'TrackGlobeController',
        resolve: {
          loggedin: function(MeanUser) {
            return MeanUser.checkLoggedin();
          }
        }
      });
  }
]);
