﻿// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Windows.ApplicationModel.Resources;
using Windows.ApplicationModel.Resources.Core;
using Windows.Globalization;
using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Messaging;
// ReSharper disable InconsistentNaming

namespace MirrorSUPINFO.Components.ComponentModel.Providers
{
    /// <summary>
    /// Provide resources for the languages
    /// </summary>
    public sealed class LanguageManager : ViewModelBase
    {
        #region Fields

        private static LanguageManager _languageManager = null;

        private readonly List<Language> _availableLanguages;
        private ResourceLoader _resourceLoader;

        #endregion

        #region Properties

        /// <summary>
        /// Gets the corresponding string to Alarm_Close
        /// </summary>
        public string Alarm_Close => _resourceLoader.GetString("Alarm_Close");

        /// <summary>
        /// Gets the corresponding string to Alarm_Dismiss
        /// </summary>
        public string Alarm_Dismiss => _resourceLoader.GetString("Alarm_Dismiss");

        /// <summary>
        /// Gets the corresponding string to Alarm_Say
        /// </summary>
        public string Alarm_Say => _resourceLoader.GetString("Alarm_Say");

        /// <summary>
        /// Gets the corresponding string to AuthenticationPage_Instruction
        /// </summary>
        public string AuthenticationPage_Instruction => _resourceLoader.GetString("AuthenticationPage_Instruction");

        /// <summary>
        /// Gets the corresponding string to AuthenticationPage_Reason
        /// </summary>
        public string AuthenticationPage_Reason => _resourceLoader.GetString("AuthenticationPage_Reason");

        /// <summary>
        /// Gets the corresponding string to AuthenticationPage_Title
        /// </summary>
        public string AuthenticationPage_Title => _resourceLoader.GetString("AuthenticationPage_Title");

        /// <summary>
        /// Gets the corresponding string to DidntGetThat
        /// </summary>
        public string DidntGetThat => _resourceLoader.GetString("DidntGetThat");

        /// <summary>
        /// Gets the corresponding string to GoodMorning
        /// </summary>
        public string GoodMorning => _resourceLoader.GetString("GoodMorning");

        /// <summary>
        /// Gets the corresponding string to GoodNight
        /// </summary>
        public string GoodNight => _resourceLoader.GetString("GoodNight");

        /// <summary>
        /// Gets the corresponding string to HaveANiceDay
        /// </summary>
        public string HaveANiceDay => _resourceLoader.GetString("HaveANiceDay");

        /// <summary>
        /// Gets the corresponding string to HereIsWhatToSay
        /// </summary>
        public string HereIsWhatToSay => _resourceLoader.GetString("HereIsWhatToSay");

        /// <summary>
        /// Gets the corresponding string to LanguageTag
        /// </summary>
        public string LanguageTag => _resourceLoader.GetString("LanguageTag");

        /// <summary>
        /// Gets the corresponding string to Madam
        /// </summary>
        public string Madam => _resourceLoader.GetString("Madam");

        /// <summary>
        /// Gets the corresponding string to Sir
        /// </summary>
        public string Sir => _resourceLoader.GetString("Sir");

        /// <summary>
        /// Gets the corresponding string to SpeechRecognition_Prefix1
        /// </summary>
        public string SpeechRecognition_Prefix1 => _resourceLoader.GetString("SpeechRecognition_Prefix1");

        /// <summary>
        /// Gets the corresponding string to SpeechRecognition_Prefix2
        /// </summary>
        public string SpeechRecognition_Prefix2 => _resourceLoader.GetString("SpeechRecognition_Prefix2");

        /// <summary>
        /// Gets the corresponding string to SpeechRecognition_Say
        /// </summary>
        public string SpeechRecognition_Say => _resourceLoader.GetString("SpeechRecognition_Say");

        /// <summary>
        /// Gets the corresponding string to SpeechRecognition_StartAction
        /// </summary>
        public string SpeechRecognition_StartAction => _resourceLoader.GetString("SpeechRecognition_StartAction");

        /// <summary>
        /// Gets the corresponding string to SpeechRecognition_To
        /// </summary>
        public string SpeechRecognition_To => _resourceLoader.GetString("SpeechRecognition_To");

        #endregion

        #region Events

        internal event EventHandler<EventArgs> LanguageChanged;

        #endregion

        #region Constructors
        
        /// <summary>
        /// Initialize a new instance of <see cref="LanguageManager"/>
        /// </summary>
        public LanguageManager()
        {
            _availableLanguages = ApplicationLanguages.ManifestLanguages.Select(tag => new Language(tag)).ToList();

            if (ApplicationLanguages.PrimaryLanguageOverride == string.Empty)
            {
                SetCurrentLanguage(_availableLanguages[0]);
            }

            _resourceLoader = ResourceLoader.GetForViewIndependentUse("MirrorSUPINFO.Components/Resources");

			RegisterMessages();
        }

        #endregion

        #region Methods

        private void RegisterMessages()
        {
            Messenger.Default.Register<NotificationMessage>(this, (notification) =>
            {
				if (notification.Target.ToString() == "ChangeMirrorLanguage")
				{
				    SetCurrentLanguage(GetLanguageFromTag(notification.Notification));
				}
            });
        }
        
        /// <summary>
        /// Get an instance of <see cref="LanguageManager"/>
        /// </summary>
        internal static LanguageManager GetProvider()
        {
            return _languageManager ?? (_languageManager = new LanguageManager());
        }
        
        /// <summary>
        /// Update the current language and update the UI
        /// </summary>
        /// <param name="language">The new current language</param>
        internal void SetCurrentLanguage(Language language)
        {
            if (language == null)
            {
                throw new ArgumentNullException(nameof(language));
            }

            ApplicationLanguages.PrimaryLanguageOverride = language.LanguageTag;
            ResourceContext.GetForViewIndependentUse().Reset();

            new System.Threading.ManualResetEvent(false).WaitOne(100);

            _resourceLoader = ResourceLoader.GetForViewIndependentUse("MirrorSUPINFO.Components/Resources");

            foreach (var propertyInfo in GetType().GetProperties())
            {
                RaisePropertyChanged(propertyInfo.Name);
            }

            if (LanguageChanged != null)
            {
                LanguageChanged(this, new EventArgs());
            }
        }

        /// <summary>
        /// Get a <see cref="Language"/> from a display name
        /// </summary>
        /// <param name="displayName">The language's display name</param>
        /// <returns>Returns a <see cref="Language"/> corresponding to the display name</returns>
        internal Language GetLanguageFromDisplayName(string displayName)
        {
            var language = _availableLanguages.FirstOrDefault(lang => lang.DisplayName.ToLower() == displayName.ToLower());

            if (language == null)
            {
                throw new ArgumentException($"Failed to get language for {displayName}");
            }

            return language;
        }

        /// <summary>
        /// Get a <see cref="Language"/> from a tag
        /// </summary>
        /// <param name="tag">The language's tag</param>
        /// <returns>Returns a <see cref="Language"/> corresponding to the tag</returns>
        internal Language GetLanguageFromTag(string tag)
        {
            var language = _availableLanguages.FirstOrDefault(lang => lang.LanguageTag.ToLower() == tag.ToLower());

            if (language == null)
            {
                throw new ArgumentException($"Failed to get language for {tag}");
            }

            return language;
        }

        /// <summary>
        /// Get the current <see cref="Language"/>
        /// </summary>
        /// <returns>Returns a <see cref="Language"/> corresponding to the current language</returns>
        internal Language GetCurrentLanguage()
        {
            return GetLanguageFromTag(ApplicationLanguages.PrimaryLanguageOverride);
        }

        #endregion
    }
}
