﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ExamplesCs
{
    public static class Extensions
    {
        public static Func<T1, T3> Compose<T1, T2, T3>(this Func<T1, T2> f, Func<T2, T3> g)
        {
            return x => g(f(x));
        }
    }

    class Program
    {
        static void Main(string[] args)
        {

            /*-------------- Composition de fonctions ---------------------*/
            Func<int, int> auCarre = x => x * x;
            Func<int, bool> estPair = y => y % 2 == 0;

            Func<int, bool> leCarreEstPair = auCarre.Compose(estPair);

            /*-------------- LINQ ---------------------*/

            var pairsQ = from i in Enumerable.Range(1, 100)
                         where i % 2 == 0
                         select i.ToString();

            var pairs = pairsQ.Aggregate((i, s) => i + "," + s);

            var paris = Enumerable.Range(1, 100)
                            .Where(i => i % 2 == 0)
                            .Select(i => i.ToString())
                            .Aggregate((i, s) => i + "," + s);

            Console.Read();

        }
    }
}
