﻿module Expressions



(* ---------------- Expressions -----------------------*)
let unChiffre = 9
let bonneReponse = if unChiffre = 42 then true else false
//val unChiffre : int = 9
//val bonneReponse : bool = false

let maListe = [for i in 1..10 -> i*i] 
//val maListe : int list = [1; 4; 9; 16; 25; 36; 49; 64; 81; 100]

let typeDeMechant nom = 
                if nom = "Ernst Stavro Blofel" then
                    "Super méchant"
                elif nom = "Lex Luthor" then
                    "Plutôt méchant"
                else
                    "On ne sait pas"
//val typeDeMechant : nom:string -> string


(* ---------------- Muabilité et immuabilité -----------------------*)
// affectation de valeur
let form = new System.Windows.Forms.Form()
form.BackColor <- System.Drawing.Color.Azure
form.Text <- "Bonjour le monde !"

// somme en gardant une variable muable
let sommeJusqua limite =
    let mutable somme = 0
    for i in [1..limite] do somme<-somme+i
    somme

(* ---------------- Recursivité -----------------------*)
// some avec une fonction récursive interne
let sommeJusquaRec limite = 
    let rec sommeInterne somme valeur =
        if valeur = 0 then somme
        else sommeInterne (somme + valeur) (valeur - 1)
    sommeInterne 0 limite
