﻿module Functions
    (* -------- fonctions --------------- *)
    let auCarre x = x * x
    //val auCarre : x:int -> int
    let estPair y = y % 2 = 0
    //val estPair : y:int -> bool

    (* -------- composition --------------- *)
    let leCarreEstPair = auCarre >> estPair
    //val leCarreEstPair : (int -> bool)

    (* -------- pipelining --------------- *)
    let leCarreEstPair12 = estPair(auCarre(12))
    let leCarreEstPair12' = 12 |> auCarre |> estPair

    (* -------- application partiel et curryfication --------------- *)
    // le format "%+d" ajoute le signe + ou - 
    printf "%+d " -3
    printf "%+d " 9
    // affiche : -3 +9 

    let afficheEntier = printf "%+d "
    //val afficheEntier : (int -> unit)
    afficheEntier -3
    afficheEntier 9
    // affiche : -3 +9

    (* -------- opérateurs infixes --------------- *)
    let (|%) valeur pourcentage = valeur * (1.0 - pourcentage/100.0)
    //val ( |% ) : valeur:float -> pourcentage:float -> float

    let prixArticle = 50.99
    let remise = 80.0 // dernière démarque
    let prixEnSolde = prixArticle |% remise

