﻿module Monads
open Microsoft.FSharp.Control.WebExtensions
open System.Net
open System.IO
open System

(*---------- Workflows asynchrones ---------------------*)
let telecharger url = 
    async{
        do! Async.Sleep 1000 // asynchrone 
        let webClient = new WebClient() // pas asynchrone
        let! html = webClient.AsyncDownloadString(new Uri(url)) // asynchrone
        return html
    }

let sites = ["http://fsharp.org";
            "http://www.tryfsharp.org";
            "https://github.com/fsharp/"]

let superContenu = 
        sites
        |> List.map telecharger
        |> Async.Parallel
        |> Async.RunSynchronously

(*---------- Workflows de séquence ---------------------*)
let unAcinq = seq { for i in 1..5 do yield i }
let sixAdix = seq{ for i in 6..10 do yield i }

let unAdix = 
        seq{ 
            yield! unAcinq
            yield! sixAdix
        }
