﻿module PatternMatching

(* -------- pattern matching --------------- *)

type AnimalUnionType = |Chien |Chat |Autre
type AnimalRecordUnion = {Espece : AnimalUnionType; Nom : string; Age : int }

let doge = {Espece = Chien; Nom = "Doge"; Age = 5}
let grumpy = {Espece = Chat; Nom = "Grumpy"; Age = 2}
let flipper = {Espece = Autre; Nom = "Flipper"; Age = 15}

let caractereAnimal animal =
    match animal with
    | {Espece = Chien} -> "Sympa"
    | {Espece = Chat} -> "Mignon"
    | {Espece = Autre} -> "Indéfini"

let caractereDoge = caractereAnimal doge
let caractereGrumpy = caractereAnimal grumpy
let caractereFlipper = caractereAnimal flipper

let villeTuple = ("San Francisco", 800000, 600)
let (nomVille, habitants, superficie) = villeTuple


