# coding: utf-8

import RPi.GPIO as GPIO
import time

LedPin1 = 12   # pin12 (Pi4J GPIO_01)
LedPin2 = 15   # pin15 (Pi4J GPIO_03)
               # pin3 la terre 

def setup():
  print("Les deux leds vont clignoter")
  
  GPIO.setmode(GPIO.BOARD)       # Numéro GPIO par location physique
  GPIO.setup(LedPin1, GPIO.OUT)  # LedPin1 en mode output
  GPIO.setup(LedPin2, GPIO.OUT)  # LedPin2 en mode output
  
def blink():
  i = 0
  while i < 15:  # Pour 15 sec
    GPIO.output(LedPin1, GPIO.HIGH) # Allume la led
    GPIO.output(LedPin2, GPIO.HIGH) # Allume la led
    time.sleep(.5)
    GPIO.output(LedPin1, GPIO.LOW)  # Eteint la led
    GPIO.output(LedPin2, GPIO.LOW)  # Eteint la led
    time.sleep(.5)
    i += 1
    
  print("Une seule led va clignoter plus lentement")

  while True: # Pour une boucle éternelle
    GPIO.output(LedPin2, GPIO.HIGH) # Allume la led
    time.sleep(1)
    GPIO.output(LedPin2, GPIO.LOW)  # Eteint la led
    time.sleep(1)
	
def destroy():
  GPIO.output(LedPin1, GPIO.LOW)   # Led éteinte
  GPIO.output(LedPin2, GPIO.LOW)   # Led éteinte
  GPIO.cleanup()                   # Ressources liberées
  
if __name__ == '__main__':   # Démarrage en Python
  setup()
  try:
    blink()
  except KeyboardInterrupt:  # Interruption avec 'Ctrl+C'
    destroy()
