﻿var AjaxTextbox = function(elmtID, url)
{
    
    // créer et retourne un nouvelle objet XMLHttpRequest
    var createXHRObject = function()
    {
        var tempXHR = null;
        
        // Instantiation de notre objet XMLHttpRequest
        if(window.XMLHttpRequest) 
           tempXHR = new XMLHttpRequest();                      // Firefox
        else if(window.ActiveXObject) 
           tempXHR = new ActiveXObject("Microsoft.XMLHTTP");    // Internet Explorer
        else   
           return null;                                         // XMLHttpRequest non supporté par le navigateur
           
        return tempXHR;
    }

    // créer un nouveau noeud div et le positionne juste en dessous de la textbox
    var writeDivResult = function()
    {
        var tempDiv = document.createElement('div');
        tempDiv.className = 'AjaxTextBoxResult';
        tempDiv.style.position = 'absolute'; 
        tempDiv.style.top = ( elmt.offsetHeight + elmt.offsetTop ) + 'px';
        tempDiv.style.left =  elmt.offsetLeft + 'px';
        tempDiv.style.width = elmt.offsetWidth + 'px';
        tempDiv.style.display = 'none';
        
        document.getElementsByTagName('body')[0].appendChild(tempDiv);
        
        return tempDiv;
    }
    
    // permet de faire une requete
    var makeRequest = function(query)
    {
        
        // initialise une nouvelle requete, avec la méthode post, sur l'url spécifié en mode asynchrone
        xhr_object.open('post', url, true);

        // lorsque la requete change d'etat
        // on vérifie qu'elle est finit (readyStat ==4)
        // si oui on indique que la requete est finit et on
        // appelle la fonction qui va afficher les resultats
        xhr_object.onreadystatechange = function() 
        {
           if(xhr_object.readyState == 4) 
           {
                isRequestActive = false;
                showResult();
           }
        }
        
        // Sert pour l'encodage des paramètres de la requete
        xhr_object.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        // Créer la requete en passant le paramètre encodé
        xhr_object.send('Query=' + escape(query));
        // on indique qu'il y a une requete d'active 
        isRequestActive = true;

    }
    
    // Cette fonction est appellé une fois la requete terminé
    // elle permet d'afficher le div de suggestion
    var showResult = function()
    {
    
        // On vérifie qu'il y ait des resultats et qu'il n'y ait pas d'erreur
        if ( (xhr_object.responseText == '') || (xhr_object.status  != 200) )
        {
            hideResult();
            return;
        }
    
        divResult.style.display = 'block';
        divResult.innerHTML = xhr_object.responseText;

        // on recupere tous les li de la réponse puis on boucle dessus
        var items = divResult.getElementsByTagName('ul')[0].childNodes; 
        for (var i = 0; i < items.length; i++)
        {
            // au passage de la souris, on change le className
            items[i].onmouseover = function()
            {
                this.className = 'Hover';
            }
            // lorsque la souris quitte, on enleve le className
            items[i].onmouseout = function()
            {
                this.className = '';
            }
            // quand on clique dessus, on met le contenu du li dans le textbox
            items[i].onmousedown= function()
            {
                elmt.value = this.innerHTML;
            }
        }
    }
    
    // Permet de cacher le div de suggestion
    var hideResult = function()
    {
        divResult.style.display = 'none';
    }


    var elmt = document.getElementById(elmtID); // On recupere la textbox
    elmt.autocomplete = "off";                  // désactive l'autocomplétion de certains navigateurs
    
    var xhr_object = createXHRObject();         // déclaration de l'objet xmlHttpRequest
    if (!xhr_object)                            // si le navigateur ne peut pas faire de l'ajax inutile d'aller plus loin
        return; 
        
    var isRequestActive = false;                // un simple boolean pour savoir s'il y a une requete en cours
    
    var divResult = writeDivResult();           // déclaration du div qui contiendra le résultat
              
    elmt.onkeyup = function()                   // abonnement sur l'evenement "relachement de la touche"
    {
        if (isRequestActive)                    // S'il y a une requete en attente on l'annule
            xhr_object.abort();
        makeRequest(elmt.value);                // On fait notre requete en passant en paramètre le contenu de la textbox
    }

    elmt.onblur = function()                    // abonnement sur l'evenement "perte du focus de la textbox"
    {
        hideResult();                           // On cache les resultats
    }
}
