package monrcp;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;

public class MyView extends ViewPart
	implements PaintListener {
	
	public static final String ID = "monrcp.myview";
	
	private Canvas canvas;
	private Display display;
	private Color red;
	private final String texte = "Programmez!"; 

	public MyView() {
		super();
	}

	@Override
	public void createPartControl(Composite parent) {
		canvas = new Canvas(parent, SWT.Paint);
		canvas.addPaintListener(this);
		display = canvas.getDisplay();
		red = display.getSystemColor(SWT.COLOR_RED);
	}

	@Override
	public void setFocus() {
	}

	public void paintControl(PaintEvent e) {
		Color blue;
		Font font;
		GC gc = e.gc;
		
		gc.setForeground(red);
		Rectangle rect =
			((Composite)e.widget).getClientArea();
		rect.height -= 1;
		rect.width -= 1;
		gc.drawRectangle(rect);
		
		font = new Font(display,"Times",
				24, SWT.ITALIC|SWT.BOLD);
		gc.setFont(font);
		blue = new Color(display, 0, 0, 255);
		gc.setForeground(blue);
		
		FontData[] fd = font.getFontData();
		Point pt = gc.textExtent(texte, 0);
		gc.drawString(texte, (rect.width - pt.x)/2,
				(rect.height - fd[0].height)/2);
		
		blue.dispose();
		font.dispose();
	}
	
	public void abonnementProgrammez() {
		Font font;
		String texte = "Abonnez vous! :-)";
		
		Color green = display.getSystemColor(SWT.COLOR_DARK_GREEN);
		Rectangle rect = canvas.getClientArea();
		
		GC gc = new GC(canvas);
		font = new Font(display,"Times",
				24, SWT.ITALIC|SWT.BOLD);
		gc.setFont(font);
		gc.setForeground(green);
		
		FontData[] fd = font.getFontData();
		gc.drawString(texte, rect.x + 10,
				rect.height - fd[0].height - 20);
		
		font.dispose();
		gc.dispose();
	}
}
