
#include <windows.h>
#include <gdiplus.h>
#include <iostream>
#include <string>

using namespace Gdiplus;
using namespace std;

#pragma comment(lib, "gdiplus.lib")


Status GetEncoderClsid(const wstring format, CLSID* pClsid)
{
	UINT  num = 0;          // nombre d'encodeurs disponibles
	UINT  size = 0;         // Taille en octets du tableau d'encodeurs
	ImageCodecInfo *pImageCodecInfo;
	char* tableau;
	Status status = UnknownImageFormat;

	GetImageEncodersSize(&num, &size);
	tableau = new char[size];
	pImageCodecInfo =
		reinterpret_cast<ImageCodecInfo*>(tableau);
	GetImageEncoders(num, size, pImageCodecInfo);

	for(UINT j = 0; j < num; ++j)
	{
		wstring ws(pImageCodecInfo[j].MimeType);

		if(ws == format)
		{
			LPOLESTR ppsz;

			*pClsid = pImageCodecInfo[j].Clsid;
			wcout << "GUID du format" << format << " ... ";
			::StringFromCLSID(*pClsid , &ppsz);
			wcout << ppsz << endl;
			::CoTaskMemFree(ppsz);
			status = Ok;
			break;
		}    
	}

	delete[] tableau;
	return status;
}

void printStatus(Status status)
{
	if(status == Ok)
		wcout << "Ok" << endl;
   else
	   wcout << "echec\n" << endl;
}


INT main()
{
	GdiplusStartupInput gdiplusStartupInput;
	ULONG_PTR gdiplusToken;
	CLSID             encoderClsid;
	EncoderParameters encoderParameters;
	ULONG             compression;
	Status            status;

	GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);
	Image* image = new Image(L"tux.png");

	// Obtenir l'encodeur
	status = GetEncoderClsid(L"image/jpeg", &encoderClsid);
	if(status != Ok)
	{
		wprintf(L"Probleme avec l'encodeur JPEG\n");
		delete image;
		return 1;
	}

	encoderParameters.Count = 1;
	encoderParameters.Parameter[0].Guid = EncoderQuality;
	encoderParameters.Parameter[0].Type = EncoderParameterValueTypeLong;
	encoderParameters.Parameter[0].NumberOfValues = 1;

	// Pas de compression
	wprintf(L"JPEG non compressee ... ");
	compression = 100;
	encoderParameters.Parameter[0].Value = &compression;
	status = image->Save(L"tux100.jpg", &encoderClsid, &encoderParameters);
	printStatus(status);

	// Compression moyenne
	wprintf(L"JPEG moyennement compressee ... ");
	compression = 50;
	encoderParameters.Parameter[0].Value = &compression;
	status = image->Save(L"tux050.jpg", &encoderClsid, &encoderParameters);
	printStatus(status);
   
	// Compression maxi
	wprintf(L"JPEG compression maximum ... ");
	compression = 0;
	encoderParameters.Parameter[0].Value = &compression;
	status = image->Save(L"tux000.jpg", &encoderClsid, &encoderParameters);
	printStatus(status);

	delete image;
	GdiplusShutdown(gdiplusToken);
	getchar();
	return 0;
}
