
public class Cordic {

	    static final double[] atan = {
	        0.7853981633974483,
	        0.4636476090008061,
	        0.24497866312686414,
	        0.12435499454676144,
	        0.06241880999595735,
	        0.031239833430268277,
	        0.015623728620476831,
	        0.007812341060101111,
	        0.0039062301319669718,
	        0.0019531225164788188,
	        9.765621895593195E-4,
	        4.882812111948983E-4
	    };
	    static final int PRECIS = atan.length;
	    
	    static double atan(double y) {
	        double a = 0.0;
	        double x = 1.0;
	        double k = 1.0;
	        double tmp;
	        
	        for(int i = 0; i < PRECIS; i++) {
	            
	            if(y >=0) {
	                tmp = x + y / k;
	                y = y - x / k;
	                x = tmp;
	                a = a + atan[i];
	            } else {
	                tmp = x - y / k;
	                y = y + x / k;
	                x = tmp;
	                a = a - atan[i];
	            }
	            k = k * 2.0;
	        }
	        return a;
	    }
	    
	    static public double atan2(double y, double x) {
	        if (y == 0.0 && x == 0.0)
	            return 0.0;
	        else if (x > 0.0)
	            return atan(y / x);
	        else if (x < 0.0)
	            return (y < 0.0) ? (-(Math.PI - atan(y / x))) : (Math.PI - atan(-y / x));
	        else // x == 0.0
	            return (y < 0.0) ? (-Math.PI / 2.0) : (Math.PI / 2.0);
	        
	    }
	    
	    static public double acos(double x) {
	        double d = asin(x);
	        if (d == Double.NaN)
	            return d;
	        else return Math.PI / 2 - d;
	    }
	    
	    static public double asin(double x) {
	        if (x < -1.0 || x > 1.0)
	            return Double.NaN;
	        else if (x == -1.0)
	            return -Math.PI / 2;
	        else if (x == 1.0)
	            return Math.PI / 2;
	        else return atan(x / Math.sqrt(1 - x * x));
	    }



}
