import java.util.Vector;

public class Utils {
	public static Vector tokenize(String s, String sep) {
		Vector v = new Vector();

		int o;
		while ((o = s.indexOf(sep)) >= 0) {
			if (o > 0) {
				v.addElement(s.substring(0, o).trim());
			} else
				v.addElement("");
			s = s.substring(o + sep.length());

		}
		v.addElement(s.trim());
		return v;
	}

	public double GPSDirection(double lat1, double lon1, double lat2,
			double lon2) {
		lat1 = Math.toRadians(lat1);
		lat2 = Math.toRadians(lat2);
		lon1 = Math.toRadians(lon1);
		lon2 = Math.toRadians(lon2);
		return Math.toDegrees(Cordic.atan2(Math.sin(lon2 - lon1)
				* Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2)
				- Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)));
	}

	final static int RAYON = 6372795;

	static int GPSDistance(double lat1, double lon1, double lat2, double lon2) {

		double dlat = Math.toRadians(lat2 - lat1);
		double dlon = Math.toRadians(lon2 - lon1);

		double tmp = Math.sin(dlat / 2) * Math.sin(dlat / 2) + Math.cos(lat1)
				* Math.cos(lat2) * Math.sin(dlon / 2) * Math.sin(dlon / 2);
		double dist = 2 * RAYON * Cordic.asin(Math.sqrt(tmp));
		return (int) dist;
	}

}
