using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Feeds.Interop;

namespace RSS2
{
    class Program
    {
    static void Main(string[] args)
    {
        FeedsManager mgr = new FeedsManagerClass();
        IFeedFolder root = (IFeedFolder) mgr.RootFolder;
        GetFeeds(root, 0);
        Console.ReadLine();
    }

    static void GetFeeds(IFeedFolder parent, int n)
    {
       string spacing = new string(' ', n);
       if (n > 0)
       {
          Console.ForegroundColor = ConsoleColor.Green;
          Console.WriteLine(spacing + "\b+" + parent.Name);
          Console.ResetColor();
       }

       Console.ForegroundColor = ConsoleColor.Yellow;
       foreach (IFeed feed in (IFeedsEnum)parent.Feeds)
          Console.WriteLine(spacing + feed.Name);

       foreach (IFeedFolder folder in (IFeedsEnum) parent.Subfolders)
            GetFeeds(folder, n + 1);
    }
    }
}