#include <cstdio>
#include <cstdlib>

using namespace std;

#include <windows.h>
#include <omp.h>

#pragma comment(lib, "vcomp.lib")

class maclasse
{
public:
	maclasse():id(0)
	{
		printf("maclasse construit\n");
	}
	maclasse(const maclasse& param)
	{
		id = param.id + 1;
		printf("Copie maclasse, id = %d\n", id);
	}
	~maclasse()
	{
		printf("maclasse detruit\n");
	}

	void DoJob()
	{
		printf("instance %d au boulot\n", id);
		::Sleep(1000);
	}

private:
	int id;
};

void go()
{
	maclasse mc;

	printf("\nDemo firstprivate avec objet C++\n"); 
	#pragma omp parallel firstprivate(mc)
	{
		for(int i=0; i<3; i++)
			mc.DoJob();
	}
	
	printf("\n\nDemo private avec objet C++\n");
	#pragma omp parallel private(mc)
	{
		for(int i=0; i<3; i++)
			mc.DoJob();
	}

}

int main ()
{
	omp_set_num_threads(3);
	go();
}
