Imports Microsoft.WindowsMobile.Forms

Public Class FormMain

    Private pClipboard As ClassClipboardPhoto

    Private Sub ComposerArborescenceDossier( _
        ByVal wRacine As TreeNodeDirectory)

        REM Informations :
        REM 
        REM Cette mthode charge dans le contrle TV_Album les dossiers
        REM Composant l'album  partir du dossier pass en paramtre
        REM 
        REM On ajoute  chaque dossier un enfant fictif de type TreeNode s'il contient des sous-dossiers
        REM Ainsi, l'arborescence est compose au fur et  mesure de la navigation

        REM On affiche le sablier
        Cursor.Current = Cursors.WaitCursor

        REM On vide, au cas o, les enfants du dossier racine
        REM Si le dossier racine est nothing on vide le treeview
        wRacine.Nodes.Clear()

        REM On liste tous les dossiers sous la racine pass en paramtre
        REM Si le dossier racine pass en paramtre est nothing,
        REM Alors on prend comme path gDossierRacine
        Dim wDossiers() As String = _
        System.IO.Directory.GetDirectories(wRacine.Path)

        REM On place chaque dossier dans l'arborescence
        For Each wDossier As String In wDossiers

            REM Cration du noeud
            Dim wNode As New TreeNodeDirectory(wDossier)

            REM Si ce dossier contient des sous dossiers
            REM Il faut lui crer un enfant fictif pour que le signe [+]
            REM Permettant d'ouvrir le dossier dans le TreeView s'affiche
            Dim wEnfants() As String = _
            System.IO.Directory.GetDirectories(wDossier)

            If wEnfants.Length > 0 Then wNode.Nodes.Add(New TreeNode)

            REM On ajoute le noeud au dossier racine
            REM Si le dossier racine est nothing alors on ajoute au TreeView directement
            wRacine.Nodes.Add(wNode)

        Next

        REM On enlve le sablier
        Cursor.Current = Cursors.Default

    End Sub

    Private Sub MEN_Quitter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MEN_Quitter.Click

        Me.Close()

    End Sub

    Private Sub TV_Album_AfterSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TV_Album.AfterSelect

        Dim wNode As TreeNodeDirectory = CType(e.Node, TreeNodeDirectory)
        ListerFichiers(wNode.Path)

    End Sub

    Private Sub TV_Album_BeforeExpand(ByVal sender As Object, _
        ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) _
        Handles TV_Album.BeforeExpand

        REM Principe :
        REM Si le premier enfant du noeud que l'on ouvre
        REM est de type TreeNode
        REM C'est que l'on a affaire  un speudo enfant
        REM qu'il faut remplacer
        REM Par les vrais dossiers (de type TreeNodeDirectory)

        If e.Node.Nodes.Count > 0 AndAlso _
            TypeOf e.Node.Nodes(0) Is TreeNode Then

            Dim wNode As TreeNodeDirectory = _
            CType(e.Node, TreeNodeDirectory)

            ComposerArborescenceDossier(wNode)

        End If

    End Sub

    Public Sub ChargerArborescence()

        REM Cration du noeud racine
        Dim wRacine As New TreeNodeDirectory(gDossierRacine)
        TV_Album.Nodes.Add(wRacine)

        REM Chargement des enfants de la racine
        ComposerArborescenceDossier(wRacine)

    End Sub

    Private Sub PrendrePhoto()

        REM Pour prendre une photo il faut qu'un noeud soit slectionn
        REM Dans l'arborescence, sinon -> Sortie
        If TV_Album.SelectedNode Is Nothing Then Exit Sub

        REM On rcupre le noeud dossier dans lequel placer la photo
        Dim wNode As TreeNodeDirectory = _
        CType(TV_Album.SelectedNode, TreeNodeDirectory)

        REM On prpare le dialogue de capture
        Dim wCapture As New CameraCaptureDialog
        With wCapture
            .InitialDirectory = "\My Documents"
            .DefaultFileName = "AlbumPhoto"
            .Mode = CameraCaptureMode.Still
            .Owner = Me
            .StillQuality = CameraCaptureStillQuality.High
            .Title = "Album Photo"
        End With

        REM On lance la capture
        Dim r As DialogResult = wCapture.ShowDialog

        REM Si l'utilisateur a bien pris la photo
        REM Et l'a accept on peut l'ajouter au dossier
        If r = Windows.Forms.DialogResult.OK Then

            REM On rcupre le fichier source
            Dim wSource As String = wCapture.FileName

            Dim f As New FormSaisieNom(wNode.Path, wSource)
            Do
                If f.ShowDialog() = Windows.Forms.DialogResult.OK Then

                    REM On copie la photo vers le bon dossier,
                    REM En lui donnant le bon nom

                    Dim wDestination As String = _
                    System.IO.Path.Combine(wNode.Path, f.Filename)

                    Try
                        System.IO.File.Move(wSource, wDestination)
                    Catch ex As Exception
                        MsgBox("Erreur de copie !", _
                            MsgBoxStyle.Exclamation)
                        Continue Do
                    End Try

                    REM On met  jour la liste
                    REM Des fichiers dans le listview
                    ListerFichiers(wNode.Path, wDestination)

                    Exit Do

                End If
            Loop

            REM Libration du dialogue de saisie du nom de la photo
            f.Dispose()

        End If

        REM Libration du dialogue de capture
        wCapture.Dispose()

    End Sub

    Private Sub ListerFichiers(ByVal wPath As String, Optional ByVal wSelection As String = "")

        Dim wItem As ListViewItemFile
        Dim wItemSelected As ListViewItemFile
        Dim wFichiers() As String = System.IO.Directory.GetFiles(wPath)

        LV_Album.Items.Clear()

        For Each wFichier As String In wFichiers

            wItem = New ListViewItemFile(wFichier)
            LV_Album.Items.Add(wItem)

            If wFichier = wSelection Then wItemSelected = wItem

        Next

        CodePPC.General.ListviewTools.Autosize(LV_Album)

        If wItemSelected IsNot Nothing Then

            wItemSelected.Selected = True
            wItemSelected.Focused = True
            LV_Album.EnsureVisible(wItemSelected.Index)

        End If

    End Sub

    Private Sub LV_Album_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles LV_Album.SelectedIndexChanged

        If LV_Album.SelectedIndices.Count = 1 Then

            Dim wItem As ListViewItemFile = CType(LV_Album.Items(LV_Album.SelectedIndices(0)), ListViewItemFile)
            Dim wWidth As Integer = PIC_Photo.Width
            If wWidth > PIC_Photo.Height Then wWidth = PIC_Photo.Height
            PIC_Photo.Image = GetThumbnail(wItem.Filename, wWidth, wWidth)

        Else

            PIC_Photo.Image = Nothing

        End If

    End Sub

    Private Sub CTX_Dossiers_Popup(ByVal sender As Object, ByVal e As System.EventArgs) Handles CTX_Dossiers.Popup

        Dim wActif As Boolean = (TV_Album.SelectedNode IsNot Nothing)

        CMEN_RenommerDossier.Enabled = wActif
        CMEN_SupprimerDossier.Enabled = wActif

    End Sub

    Private Sub CMEN_NouveauDossier_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_NouveauDossier.Click

        Dim wReponse As String = InputBox("Veuillez saisir le nom du nouveau dossier")
        If wReponse <> "" Then

            Dim wPath As String = CType(TV_Album.SelectedNode, TreeNodeDirectory).Path
            wPath = System.IO.Path.Combine(wPath, wReponse)

            Try
                System.IO.Directory.CreateDirectory(wPath)
            Catch ex As Exception
                MsgBox("Impossible de crer le nouveau dossier !", MsgBoxStyle.Exclamation)
                MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                Exit Sub
            End Try

            Dim wNewDossier As New TreeNodeDirectory(wPath)
            TV_Album.SelectedNode.Nodes.Add(wNewDossier)
            TV_Album.SelectedNode.Expand()
            TV_Album.SelectedNode = wNewDossier

        End If

    End Sub

    Private Sub CMEN_RenommerDossier_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_RenommerDossier.Click

        Dim wNode As TreeNodeDirectory = CType(TV_Album.SelectedNode, TreeNodeDirectory)
        Dim wReponse As String = InputBox("Veuillez saisir le nouveau nom pour ce dossier", , wNode.Text)
        If wReponse <> "" Then

            Dim wSource As String = wNode.Path
            Dim wDestination As String = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(wNode.Path), wReponse)

            Try
                System.IO.Directory.Move(wSource, wDestination)
            Catch ex As Exception
                MsgBox("Impossible de renommer le dossier !", MsgBoxStyle.Exclamation)
                MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                Exit Sub
            End Try

            Dim wNewDossier As New TreeNodeDirectory(wDestination)
            Dim wParent As TreeNodeDirectory = wNode.Parent

            If wParent Is Nothing Then
                TV_Album.Nodes.Clear()
                ComposerArborescenceDossier(wNode)
            Else
                wParent.Nodes.Clear()
                ComposerArborescenceDossier(wParent)
            End If

        End If

    End Sub

    Private Sub CMEN_SupprimerDossier_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_SupprimerDossier.Click

        Dim wNode As TreeNodeDirectory = CType(TV_Album.SelectedNode, TreeNodeDirectory)
        If MsgBox("Etes-vous sr de vouloir supprimer ce dossier ?", MsgBoxStyle.Question Or MsgBoxStyle.YesNo Or MsgBoxStyle.DefaultButton2) = MsgBoxResult.Yes Then

            Try
                System.IO.Directory.Delete(wNode.Path)
            Catch ex As Exception
                MsgBox("Impossible de supprimer le dossier !", MsgBoxStyle.Exclamation)
                MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                Exit Sub
            End Try

            If wNode.Parent Is Nothing Then
                TV_Album.Nodes.Remove(wNode)
            Else
                wNode.Remove()
            End If

        End If

    End Sub

    Private Sub CTX_Fichiers_Popup(ByVal sender As Object, _
        ByVal e As System.EventArgs) _
        Handles CTX_Fichiers.Popup

        Dim wActif As Boolean = (LV_Album.SelectedIndices.Count = 1)

        CMEN_SupprimerPhoto.Enabled = wActif
        CMEN_RenommerPhoto.Enabled = wActif

        CMEN_CopierPhoto.Enabled = wActif
        CMEN_CouperPhoto.Enabled = wActif

        CMEN_CollerPhoto.Enabled = (pClipboard IsNot Nothing)

    End Sub

    Private Sub CMEN_PrendrePhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_PrendrePhoto.Click

        PrendrePhoto()

    End Sub

    Private Sub CMEN_SupprimerPhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_SupprimerPhoto.Click

        If LV_Album.SelectedIndices.Count = 1 Then

            Dim wFile As ListViewItemFile = CType(LV_Album.Items(LV_Album.SelectedIndices(0)), ListViewItemFile)
            If MsgBox("Etes-vous sr de vouloir supprimer cette photo ?", MsgBoxStyle.Question Or MsgBoxStyle.YesNo Or MsgBoxStyle.DefaultButton2) = MsgBoxResult.Yes Then

                Try
                    System.IO.File.Delete(wFile.Filename)
                Catch ex As Exception
                    MsgBox("Impossible de dtruire cette photo !", MsgBoxStyle.Exclamation)
                    MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                    Exit Sub
                End Try

                LV_Album.Items.Remove(wFile)

            End If

        End If

    End Sub

    Private Sub CMEN_RenommerPhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_RenommerPhoto.Click

        If LV_Album.SelectedIndices.Count = 1 Then

            Dim wFile As ListViewItemFile = CType(LV_Album.Items(LV_Album.SelectedIndices(0)), ListViewItemFile)

            Dim wReponse As String = InputBox("Veuillez saisir le nouveau nom pour cette photo", , System.IO.Path.GetFileNameWithoutExtension(wFile.Filename))
            If wReponse <> "" Then

                Dim wNewFilename As String = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(wFile.Filename), wReponse) & System.IO.Path.GetExtension(wFile.Filename)

                Try

                    System.IO.File.Move(wFile.Filename, wNewFilename)

                Catch ex As Exception
                    MsgBox("Impossible de renommer cette photo !", MsgBoxStyle.Exclamation)
                    MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                    Exit Sub
                End Try

                Dim wFile2 As New ListViewItemFile(wNewFilename)
                LV_Album.Items.Insert(wFile.Index, wFile2)
                LV_Album.Items.Remove(wFile)

            End If

        End If


    End Sub

    Private Sub CMEN_CopierPhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_CopierPhoto.Click

        If LV_Album.SelectedIndices.Count = 1 Then

            Dim wItem As ListViewItemFile = CType(LV_Album.Items(LV_Album.SelectedIndices(0)), ListViewItemFile)
            pClipboard = New ClassClipboardPhoto(wItem.Filename, ClassClipboardPhoto.OperationEnum.Copier)

        End If

    End Sub

    Private Sub CMEN_CouperPhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_CouperPhoto.Click


        If LV_Album.SelectedIndices.Count = 1 Then

            Dim wItem As ListViewItemFile = CType(LV_Album.Items(LV_Album.SelectedIndices(0)), ListViewItemFile)
            pClipboard = New ClassClipboardPhoto(wItem.Filename, ClassClipboardPhoto.OperationEnum.Couper)

        End If

    End Sub

    Private Sub CMEN_CollerPhoto_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CMEN_CollerPhoto.Click

        If pClipboard IsNot Nothing AndAlso TV_Album.SelectedNode IsNot Nothing Then

            Dim wDossier As TreeNodeDirectory = CType(TV_Album.SelectedNode, TreeNodeDirectory)
            Dim wFichierDestination As String = System.IO.Path.Combine(wDossier.Path, System.IO.Path.GetFileName(pClipboard.Filename))

            Try

                Select Case pClipboard.Operation

                    Case ClassClipboardPhoto.OperationEnum.Copier
                        System.IO.File.Copy(pClipboard.Filename, wFichierDestination)

                    Case ClassClipboardPhoto.OperationEnum.Couper
                        System.IO.File.Move(pClipboard.Filename, wFichierDestination)

                End Select

            Catch ex As Exception

                MsgBox("Impossible d'effectuer l'opration !", MsgBoxStyle.Exclamation)
                MsgBox(String.Format("Erreur : {0}", ex.Message), MsgBoxStyle.Information)
                Exit Sub

            End Try

            ListerFichiers(wDossier.Path, wFichierDestination)

        End If

    End Sub

    Private Sub MEN_About_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MEN_About.Click

        MsgBox("Album Photo pour Pocket PC. Dvelopp par Stphane Sibu", MsgBoxStyle.Information, "A propos de...")

    End Sub

End Class