<?php
/**
 * Fichier demo FFMPEG/PHP
 * montre le principe d'utilisation de FFMPEG/PHP pour :
 * - crer un objet ffmpeg-php,
 * - accder  une vido,
 * - faire la diffrence entre un fichier audio et un fichier vido
 * - extraire des informations des mdias.
 * 
 * @author Nicolas Cerisier <nicolas.cerisier@gmail.com>
 */

/**
 * Init: 
 * - dfinition d'un emplacement pour les mdias
 * - prsence de ffmpeg
 */

// dfinition de la collection de medias
$media_path = 'medias';

// Confirme que l'extension est presente
$extension = "ffmpeg";
$extension_soname = $extension . "." . PHP_SHLIB_SUFFIX;
$extension_fullname = PHP_EXTENSION_DIR . "/" . $extension_soname;
if (!extension_loaded('ffmpeg')) {
	dl($extension_soname) or die("Impossible de trouver l'extension: $extension_fullname\n");
}

/**
 * Traitements
 * - on parcourt le repertoire,
 * - on ouvre le mdia,
 * - on test le mdia (type)
 * - on extrait des informations
 */

if(is_dir($media_path) && $dir = opendir($media_path)) {
	while (($media = readdir($dir)) !== false) {
		if($media != '.' && $media != '..'){
			$fullpath = $media_path.'/'.$media;
			$HTML .= "<b> Nom du mdia : $media ($fullpath) </b>\n";
			
			// Instanciation de ffmpeg_movie
			if(is_object($mediaObj = new ffmpeg_movie($fullpath) )){
				
				/**
				 * FFMPEG-PHP est normalement destin  trater des vidos.
				 * Mais les mthodes fournies permettent d'largir aux fichiers audios si on considere qu'un fichier audio
				 * est une vido sans codec video mais avec codec audio ;)
				 */
				if($videoCodec = $mediaObj->getVideoCodec()) {
					$HTML .= "<li> Le fichier est un fichier vido \n";
					$HTML .= "<li> Codec Video : ".$videoCodec;
					$HTML .= "<li> Codec Audio : ".$mediaObj->getAudioCodec();
					$HTML .= "<li> Duree : ".$mediaObj->getDuration();
					$HTML .= "<li> Taille : ".$mediaObj->getFrameHeight()."x".$mediaObj->getFrameWidth();
					$HTML .= "<li> BitRate : ".$mediaObj->getBitRate();
					
				} elseif($audioCodec = $mediaObj->getAudioCodec()) {
					$HTML .= "<li> Le fichier semble etre un fichier audio: pas de frames, mais une piste audio\n";
					$HTML .= "<li> Codec Audio : ".$audioCodec;
					$HTML .= "<li> Artist (iD3) : ".$mediaObj->getArtist();
					$HTML .= "<li> Album (iD3) : ".$mediaObj->getAlbum();
					$HTML .= "<li> Artist (iD3) : ".$mediaObj->getArtist();
					$HTML .= "<li> Genre (iD3) : ".$mediaObj->getGenre();
					$HTML .= "<li> BitRate : ".$mediaObj->getBitRate();
				} else {
					$HTML .= "<b> PROBLEME </b> : le fichier n'a ni audio ni frames valides";
				}
				
				$HTML .= "\n\n";
			} else {
				$HTML .= "<b> ERREUR </b> : impossible d'instancier FFMPEG / Media invalide \n";
			}
			
		}
	}
}

print nl2br($HTML);
?>