<?php
/**
 * Fichier demo FFMPEG/PHP
 * montre le principe d'utilisation de FFMPEG/PHP pour :
 * - crer un objet ffmpeg-php,
 * - accder  une vido,
 * - faire la diffrence entre un fichier audio et un fichier vido
 * - extraire des informations des mdias.
 * - ajoute la generation de plusieurs miniatures
 * 
 * @author Nicolas Cerisier <nicolas.cerisier@gmail.com>
 */

/**
 * Init: 
 * - dfinition d'un emplacement pour les mdias
 * - prsence de ffmpeg
 */

// dfinition de la collection de medias
$media_path = 'medias';

// Confirme que l'extension est presente
$extension = "ffmpeg";
$extension_soname = $extension . "." . PHP_SHLIB_SUFFIX;
$extension_fullname = PHP_EXTENSION_DIR . "/" . $extension_soname;
if (!extension_loaded('ffmpeg')) {
	dl($extension_soname) or die("Impossible de trouver l'extension: $extension_fullname\n");
}

/**
 * Traitements
 * - on parcourt le repertoire,
 * - on ouvre le mdia,
 * - on test le mdia (type)
 * - on extrait des informations
 * - on genere une miniature si possible
 */

if(is_dir($media_path) && $dir = opendir($media_path)) {
	while (($media = readdir($dir)) !== false) {
		if($media != '.' && $media != '..'){
			$fullpath = $media_path.'/'.$media;
			$HTML .= "<b> Nom du mdia : $media ($fullpath) </b>\n";
			
			// Instanciation de ffmpeg_movie
			if(is_object($mediaObj = new ffmpeg_movie($fullpath) )){
				
				/**
				 * FFMPEG-PHP est normalement destin  trater des vidos.
				 * Mais les mthodes fournies permettent d'largir aux fichiers audios si on considere qu'un fichier audio
				 * est une vido sans codec video mais avec codec audio ;)
				 */
				if($videoCodec = $mediaObj->getVideoCodec()) {
					$HTML .= "<li> Le fichier est un fichier vido \n";
					$HTML .= "<li> Codec Video : ".$videoCodec;
					$HTML .= "<li> Codec Audio : ".$mediaObj->getAudioCodec();
					$HTML .= "<li> Duree : ".$mediaObj->getDuration();
					$HTML .= "<li> Taille : ".$mediaObj->getFrameHeight()."x".$mediaObj->getFrameWidth();
					$HTML .= "<li> BitRate : ".$mediaObj->getBitRate();
					
					/**
					 * ------------------------------------------------------------------------------------------------- 
					 * GENERATION DES MINIATURES
					 * - nous allons generer 3 images ( 5%, 50% et 90% de la vido)
					 * - la miniature sera redimensionner  50% de la taille de la video d'origine
					 * - nous allons inserer un tag dans l'image
					 * - la miniature est generee dans un fichier temporaire sur le filesystem
					 * ------------------------------------------------------------------------------------------------- 
					 */
					$frameset = array(0.1,0.5,0.9);
					$tag = "programmez !";
					$ratio = 0.5;
					$thumb_path = "thumbs";
					$HTML .= "\n\n";
					
					// Pour chaque frame demandee
					foreach($frameset as $keyframe){
						
						// on commence par calculer son emplacement dans la vido
						$keyframe = (float) $keyframe * (float) $mediaObj->getDuration() * 25;
						
						// puis on extrait la frame de la vido
						if ($ff_frame = $mediaObj->getFrame($keyframe)) {
							
							// on redimensionne la frame
							$ff_frame->resize($mediaObj->getFrameWidth()*$ratio, $mediaObj->getFrameHeight()*$ratio ); 
							
							// on genere un nom de fichier pour le stockage
							$thumbnailName = preg_replace('/ /','_',$thumb_path.'/'.time().'-'.$keyframe.'-'.$media.'.png');

							// et on "transmet" la frame  GD, ou nous allons pouvoir terminer le traitement
			    			if ($gd_image = $ff_frame->toGDImage()) {
								
								$textcolor = imagecolorallocate($gd_image, 0, 0, 255);
								imagestring($gd_image, 10, 10, 10, $tag, $textcolor);		// insert un texte sur l'image
								imagepng($gd_image, $thumbnailName);
								imagedestroy($gd_image);
			    	    		
								// et enfin on affiche
			    	    		$HTML .= "<img src=\"$thumbnailName\" />";
			    			}
			    	    }
					}
					
					// ------------------------------------------------------------------------------------------------- 

					
				} elseif($audioCodec = $mediaObj->getAudioCodec()) {
					$HTML .= "<li> Le fichier semble etre un fichier audio: pas de frames, mais une piste audio\n";
					$HTML .= "<li> Codec Audio : ".$audioCodec;
					$HTML .= "<li> Artist (iD3) : ".$mediaObj->getArtist();
					$HTML .= "<li> Album (iD3) : ".$mediaObj->getAlbum();
					$HTML .= "<li> Artist (iD3) : ".$mediaObj->getArtist();
					$HTML .= "<li> Genre (iD3) : ".$mediaObj->getGenre();
					$HTML .= "<li> BitRate : ".$mediaObj->getBitRate();
					
					
				} else {
					$HTML .= "<b> PROBLEME </b> : le fichier n'a ni audio ni frames valides";
				}
				
				$HTML .= "\n\n";
			} else {
				$HTML .= "<b> ERREUR </b> : impossible d'instancier FFMPEG / Media invalide \n";
			}
			
		}
	}
}

print nl2br($HTML);
?>