
package demoabstractfactorypattern;


import java.util.Vector;

enum TypeEntite {
    TYPESOLDAT, 
    TYPETANK,
    TYPEBOULANGER,
    TYPEMECANICIEN,
}

abstract class Entite {
    protected String categorie;
    protected int pv; // Points de vie
        
    public void init(String categorie, int pv) {
        this.categorie = categorie;
        this.pv = pv;
    }
    
    public void display() {
        System.out.println(categorie + ", pv: " + pv);
    }
    
    abstract public void action();
}

class Soldat extends Entite {
    
    @Override
    public void action() {
        System.out.println("Action soldatesque");
    }
}

class Tank extends Entite {
    @Override
    public void action() {
        System.out.println("Action blindee");
    }
}

class Boulanger extends Entite {
    
    @Override
    public void action() {
        System.out.println("Action se sortir du petrin");
    }
}

class Mecanicien extends Entite {
    @Override
    public void action() {
        System.out.println("Action mecanique");
    }
}


abstract class JeuFabrique {
    abstract Entite creerEntite(TypeEntite type);
}

class FabriqueMilitaire extends JeuFabrique{

    Entite creerEntite(TypeEntite type) {
        Entite e;
        switch (type) {
            case TYPESOLDAT:
            default:
               e = new Soldat();
               e.init("Soldat", 10);
               break;
            case TYPETANK:
               e = new Tank();
               e.init("Tank", 500);
               break;    
        }
        return e;
    }
}

class FabriqueCivile extends JeuFabrique{

    Entite creerEntite(TypeEntite type) {
        Entite e;
        switch (type) {
            case TYPEBOULANGER:
            default:
               e = new Boulanger();
               e.init("Boulanger", 30);
               break;
            case TYPEMECANICIEN:
               e = new Mecanicien();
               e.init("mecanicien", 40);
               break;    
        }
        return e;
    }
}


class PanneauJeu {
    Vector<Entite> pieces = new Vector<Entite>();
    JeuFabrique fabrique;
   
    PanneauJeu(JeuFabrique fabrique) {
        this.fabrique = fabrique;
    }
    
    public void creerEntite(TypeEntite type) {
        pieces.add(fabrique.creerEntite(type));
    }
    
    public void jouer() {
        for(Entite e : pieces) {
            e.display();
            e.action();
        }
    }
}

public class JeuFabriqueAbstraite {
    public static void main(String[] args) {
        System.out.println("Demo Simple Factory");
        PanneauJeu militaire = new PanneauJeu(new FabriqueMilitaire());
        PanneauJeu civil = new PanneauJeu(new FabriqueCivile());
        // Ici le joueur clique sur les interfaceq
        // et crée des entités
        militaire.creerEntite(TypeEntite.TYPESOLDAT);
        militaire.creerEntite(TypeEntite.TYPETANK);
        civil.creerEntite(TypeEntite.TYPEBOULANGER);
        civil.creerEntite(TypeEntite.TYPEMECANICIEN);

        // puis le jeu se déroule
        militaire.jouer();
        civil.jouer();
        // et ainsi de suite
    }
} 
