
package demofactorypattern;


import java.util.Vector;

enum TypeEntite {
    TYPESOLDAT, 
    TYPETANK, 
}

abstract class Entite {
    protected String categorie;
    protected int pv; // Points de vie
        
    public void init(String categorie, int pv) {
        this.categorie = categorie;
        this.pv = pv;
    }
    
    public void display() {
        System.out.println(categorie + ", pv: " + pv);
    }
    
    abstract public void action();
}

class Soldat extends Entite {
    
    @Override
    public void action() {
        System.out.println("Action soldatesque");
    }
}

class Tank extends Entite {
    @Override
    public void action() {
        System.out.println("Action blindee");
    }
}

class SimpleFabrique {

    Entite creerEntite(TypeEntite type) {
        Entite e;
        switch (type) {
            case TYPESOLDAT:
            default:
               e = new Soldat();
               e.init("Soldat", 10);
               break;
            case TYPETANK:
               e = new Tank();
               e.init("Tank", 500);
               break;    
        }
        return e;
    }
}

class PanneauJeu {
    Vector<Entite> pieces = new Vector<Entite>();
    SimpleFabrique fabrique = new SimpleFabrique();
   
    public void creerEntite(TypeEntite type) {
        pieces.add(fabrique.creerEntite(type));
    }
    
    public void jouer() {
        for(Entite e : pieces) {
            e.display();
            e.action();
        }
    }
}

public class JeuSimpleFabrique {
    public static void main(String[] args) {
        System.out.println("Demo Simple Factory");
        PanneauJeu pj = new PanneauJeu();
        // Ici le joueur clique sur l'interface
        // et crée des entités
        pj.creerEntite(TypeEntite.TYPESOLDAT);
        pj.creerEntite(TypeEntite.TYPETANK);
        // puis le jeu se déroule
        pj.jouer();
        // et ainsi de suite
    }
} 
