
package fred;

import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;



class FonctionLog implements Function2D {
    public double getValue(double d) {
        // Le domaine de dfinition est implicitement
        // dfini lors de la cration du Dataset dans
        // DemoFonction
        return Math.log(d);
    }
}

public class DemoFonction extends JFrame {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 7974821633815481497L;


	public DemoFonction() {
        
        Function2D f2d = new FonctionLog();
        XYDataset data  =
                DatasetUtilities.sampleFunction2D(
                f2d, 1.0, 10.0, 1000, "y=ln(x)");
        JFreeChart chart = ChartFactory.createXYLineChart(
                "Fonction logarithme",
                "x",
                "ln(x)",
                data,
                PlotOrientation.VERTICAL,
                true, true, false);
        
        // Personnaliser l'affichage
        XYPlot xyplot = (XYPlot)chart.getPlot();
        // Personnalisation de l'axe vertical
        NumberAxis na = (NumberAxis)xyplot.getRangeAxis();
        na.setTickUnit(new NumberTickUnit(1.0));
        na.setLabelAngle(Math.PI/2.0);
        na.setAutoRange(false);
        na.setRange(0.0, 10.0);
        // Personnalisation de l'axe horizontal
        na = (NumberAxis)xyplot.getDomainAxis();
        
        ChartPanel chartPanel = new ChartPanel(chart);
        setContentPane(chartPanel);
    }
    
    
    public static void main(String[] args) {
        DemoFonction demo = new DemoFonction();
        demo.setDefaultCloseOperation(EXIT_ON_CLOSE);
        demo.setSize(500, 520);
        demo.setVisible(true);
    }
}