/*
 * DemoXYPlot.java
 *
 * Created on 13 mars 2007, 17:45
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package fred;

import java.lang.Math;
import javax.swing.JFrame;

import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;


class XYSeriesCreator {
    public static XYSeries createXYSeries(String name)
    {
        int year = 2000;
        XYSeries xys = new XYSeries(name);
        for(int i=year; i<year+11; i++)
        {
            xys.add(new Integer(i), new Double(Math.random()*100.0));
        }
        return xys;
    }
}

public class DemoXYPlot extends JFrame {
	private static final long serialVersionUID =
		8648338234606842879L;
	public DemoXYPlot() {
        XYSeries xys1 = XYSeriesCreator.createXYSeries("XY Series 1");
        XYSeries xys2 = XYSeriesCreator.createXYSeries("XY Series 2");
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(xys1);
        data.addSeries(xys2);
        JFreeChart chart = ChartFactory.createXYLineChart(
            "Demo XY Series",
            "Annes", 
            "Bnfices", 
            data,
            PlotOrientation.VERTICAL,
            true,
            true,
            false
        );

        ChartPanel chartPanel = new ChartPanel(chart);
        setContentPane(chartPanel);
    }
    public static void main(String[] args) {
        DemoXYPlot demo = new DemoXYPlot();
        demo.setDefaultCloseOperation(EXIT_ON_CLOSE);
        demo.setSize(400, 300);
        demo.setVisible(true);
    }
}
