
package patternstrategy;

interface Arme {
    public void tirer();
}

class Torpille implements Arme {
    public void tirer() {
	System.out.println("tir torpille");
    }
}

class Fusil implements Arme {
    public void tirer() {
	System.out.println("tir fusil");
    }
}

class Pistolet implements Arme {
    public void tirer() {
	System.out.println("tir pistolet");
    }
}

class Bazooka implements Arme {
    public void tirer() {
	System.out.println("tir bazooka");
    }
}

class UniteCombat {
    private int point_vie;
    private Arme arme;
    private String id;
    
    UniteCombat(String id, int point_vie, Arme arme) {
	this.point_vie = point_vie;
	this.id = id;
	this.arme = arme;
    }
    public void tirer() {
	System.out.print(id + ": ");
	arme.tirer();
    }
    public void setArme(Arme arme) {
	this.arme = arme;
    }
}


public class BonneStrategie {
    
    public static void main(String[] args) {
	System.out.println("Debut partie");
	UniteCombat[] armee = new UniteCombat[2];
	armee[0] = new UniteCombat("Soldat", 10, new Fusil());
	armee[1] = new UniteCombat("Sous-Marin", 1000, new Torpille());
	armee[0].tirer();
	armee[0].setArme(new Pistolet());
	armee[0].tirer();
	armee[0].setArme(new Bazooka());
	armee[0].tirer();
	armee[1].tirer();
	System.out.println("Fin partie");	
    }
}
