package fred;

import java.util.Scanner;


public class PremierRec {
    int diviseur;
    
    public int getDiviseur() {
	return diviseur;
    }
    
    
    public boolean isPremier(int n) {
	int limite;
	
	// 2 est premier
	if(n==2 || n==3)
		return true;
	// Si n est pair
	if((n%2)==0)
	{
	    diviseur = 2;
	    return false;
	}
	
	limite = (int)(Math.sqrt(n) + 1);
	return isSubPremier(n, 3, limite);
    }
    
    private boolean isSubPremier(int n, int div, int limite) {
	if(div >= limite || div <0)
	    return true;
	
	if((n%div) ==0)
	{
	    diviseur = div;
	    return false;
	}
	
	return isSubPremier(n, n+2, limite);
    }
    
    public static void main(String[] args) {
	int nombre;
	long t1, t2;
	boolean result;
	
	System.out.print("Donnez un nombre superieur a 1: ");
	Scanner scanner = new Scanner(System.in);
	nombre = scanner.nextInt();
	if(nombre < 2) {
	    System.out.println("Donnez un nombre superieur a 1 !!");
	    System.exit(1);
	}
	
	PremierRec premier = new PremierRec();
	t1 = System.currentTimeMillis();
	result = premier.isPremier(nombre);
	if(result)
	    System.out.printf("\n%d est premier\n", nombre);
	else
	{
	    System.out.printf("\n%d n'est pas premier, divisible par %d\n",
		    nombre, premier.getDiviseur());
	}
	t2 = System.currentTimeMillis();
	System.out.printf("Resultat obtenu en %d millisecondes\n", t2 - t1);
    }
}