﻿using Microsoft.Synchronization;
using Microsoft.Synchronization.Files;

namespace MasterSlaveCorbeille
{
    class Program
    {
        private string masterpath = "D:\\master";
        private string slavepath = "D:\\slave";
        private string mdfile = "filesync.metadata";
        private string tmp = "d:\\temp";
        private string masterCorbeille = "D:\\mastercorbeille";
        private string slaveCorbeille = "D:\\slavecorbeille";

        private void Run()
        {
            // pas de filtre
            FileSyncProvider masterProvider = new FileSyncProvider(masterpath,  null,
                FileSyncOptions.None, 
                masterpath, "filesync.metadata", tmp,
                masterCorbeille);

            FileSyncProvider slaveProvider = new FileSyncProvider(slavepath, null,
                FileSyncOptions.None,
                slavepath, "filesync.metadata", tmp,
                slaveCorbeille);
            

            SyncOrchestrator orchestrator = new SyncOrchestrator();
            orchestrator.LocalProvider = masterProvider;
            orchestrator.RemoteProvider = slaveProvider;
            orchestrator.Direction = SyncDirectionOrder.UploadAndDownload;
            orchestrator.Synchronize();
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Run();
        }
    }
}
